<?php

namespace AppBundle\Form\Type\Module;

use AppBundle\Entity\Module;
use AppBundle\Entity\Testimonial;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\ModuleType;
use AppBundle\Enum\HtmlTag;
use AppBundle\Helper\ModuleHelper;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TestimonialsListType extends AbstractType
{
    private $utils;
    private $em;
    private $html_tags = array();

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils, EntityManagerInterface $em)
    {
        $this->utils = $utils;
        $this->em = $em;
        $this->html_tags = $utils->trans(HtmlTag::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $items_list = $this->em->getRepository(Testimonial::class)->findSimpleListBy([
            'isActive' => true, 
        ], [
            'witness' => 'ASC'
        ]);
        
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.module.testimonials_list.title.label',
                'required' => false,
            ))
            ->add('title_tag', ChoiceType::class, array(
                'choices' => array_flip($this->html_tags),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'label' => 'form.module.testimonials_list.title_tag.label',
                'placeholder' => 'form.none.label',
                'required' => false,
                'attr' => array (
                    'class' => 'form-row-childs-inline'
                )
            ))
            ->add('mode', ChoiceType::class, array(
                'choices' => array_flip(array(
                    'created' => 'form.module.testimonials_list.mode.created',    
                    'featured' => 'form.module.testimonials_list.mode.featured',    
                )),
                'choice_translation_domain' => 'form',
                'label' => 'form.module.testimonials_list.mode.label',
                'required' => true,
            ))
            ->add('nb_items', NumberType::class, array(
                'label' => 'form.module.testimonials_list.nb_items.label',
                'help' => 'form.module.testimonials_list.nb_items.help',
                'required' => true,
            ))
            ->add('items', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'multiple' => true,
                'label' => 'form.module.testimonials_list.items.label',
                'help' => 'form.module.testimonials_list.items.help',
                'required'  => false,
            ))
            ->add('btn_text', TextType::class, array(
                'label' => 'form.module.testimonials_list.btn_text.label',
                'required' => false,
            ))
            ->add('btn_link', TextType::class, array(
                'label' => 'form.module.testimonials_list.btn_link.label',
                'required' => false,
            ))
        ;     
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
