<?php

namespace AppBundle\Form\Type\Module;

use AppBundle\Entity\Module;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\ModuleType;
use AppBundle\Enum\HtmlTag;
use AppBundle\Helper\ModuleHelper;
use AppBundle\Translation\ConstTranslator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SocialType extends AbstractType
{
    private $utils;
    private $html_tags = array();

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->utils = $utils;
        $this->html_tags = $utils->trans(HtmlTag::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.module.social.title.label',
                'required' => false,
            ))
            ->add('title_tag', ChoiceType::class, array(
                'choices' => array_flip($this->html_tags),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'label' => 'form.module.social.title_tag.label',
                'placeholder' => 'form.none.label',
                'required' => false,
                'attr' => array (
                    'class' => 'form-row-childs-inline'
                )
            ))
            ->add('facebook', UrlType::class, array(
                'label' => 'form.module.social.facebook.label',
                'required' => false,
            ))
            ->add('twitter', UrlType::class, array(
                'label' => 'form.module.social.twitter.label',
                'required' => false,
            ))
            ->add('linkedin', UrlType::class, array(
                'label' => 'form.module.social.linkedin.label',
                'required' => false,
            ))
            ->add('youtube', UrlType::class, array(
                'label' => 'form.module.social.youtube.label',
                'required' => false,
            ))
            // ->add('flickr', UrlType::class, array(
            //     'label' => 'form.module.social.flickr.label',
            //     'required' => false,
            // ))
            ->add('instagram', UrlType::class, array(
                'label' => 'form.module.social.instagram.label',
                'required' => false,
            ))
        ;   
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
