<?php

namespace AppBundle\Form\Type\Module;

use AppBundle\Entity\Media;
use AppBundle\Entity\Module;
use AppBundle\Enum\MediaType;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\ModuleType;
use AppBundle\Enum\HtmlTag;
use AppBundle\Helper\ModuleHelper;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Liip\ImagineBundle\Controller\ImagineController;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PicturesListType extends AbstractType
{
    private $utils;
    private $em;
    private $imagineController;
    private $html_tags = array();

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils, EntityManagerInterface $em, ImagineController $imagineController)
    {
        $this->utils = $utils;
        $this->em = $em;
        $this->imagineController = $imagineController;
        $this->html_tags = $utils->trans(HtmlTag::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    { 
        $request = Request::createFromGlobals();

        // $items_list = $this->em->getRepository(Media::class)->findSimpleListBy([
        //     'type' => 'picture',
        // ], [
        //     'title' => 'ASC'
        // ]);

        $items = $this->em->getRepository(Media::class)->findBy([
            'is_active' => true,
            'type' => MediaType::PICTURE,
        ], [
            'title' => 'ASC'
        ]);

        foreach ( $items as $media ) {
            $label = '<figure>';
            
            $path = $media->getWebPathPicture();

            if (!empty($path) && file_exists($media->getAbsolutePicture())) {
            // if (!empty($path)) {
                $image = $this->imagineController->filterAction($request, $path, '50H');

                if (method_exists($image, 'getTargetUrl') && $image->getTargetUrl()) {
                    $label .= '<a class="fancybox" href="/' . $path . '" />';
                    $label .= '<img src="' . $image->getTargetUrl() . '" alt="" />';
                    $label .= '</a>';
                }
            }

            $label .= '<figcaption>' . $media->getTitle() . '</figcaption>';
            $label .= '</figure>';

            
            $items_list[$media->getId()] = $label;
        }
        
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.module.pictures_list.title.label',
                'required' => false,
            ))
            ->add('title_tag', ChoiceType::class, array(
                'choices' => array_flip($this->html_tags),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'label' => 'form.module.pictures_list.title_tag.label',
                'placeholder' => 'form.none.label',
                'required' => false,
                'attr' => array (
                    'class' => 'form-row-childs-inline'
                )
            ))
            ->add('auto_items', CheckboxType::class, array(
                'label' => 'form.module.pictures_list.auto_items.label',
                'help' => 'form.module.pictures_list.auto_items.help',
                'required' => false,
            ))
            ->add('items', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'multiple' => true,
                'label' => 'form.module.pictures_list.items.label',
                'required'  => false,
            ))
            ->add('btn_text', TextType::class, array(
                'label' => 'form.module.pictures_list.btn_text.label',
                'required' => false,
            ))
            ->add('btn_link', TextType::class, array(
                'label' => 'form.module.pictures_list.btn_link.label',
                'required' => false,
            ))
        ;     
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
