<?php

namespace AppBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class MerITDLCAdminType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('answer', ChoiceType::class, [
            'label' => 'form.itdlc.answer.label',
            'required' => true,
            'choices' => ['Date 1' => 'date1', 'Date 2' => 'date2', 'Date 3' => 'date3', 'Autre date' => 'autre', 'Pas intéressé' => 'non']
        ])
        ->add('firstDate', DateType::class, array(
            'label' => 'form.link.firstDate.label',
            'widget' => 'single_text',
            'html5' => true,
            'required'   => true,
        ))
        
        ->add('firstDateStartTime', TimeType::class, array(
            'label' => 'form.availability.startTime.label',
            'widget' => 'choice',
            'hours' => range(8, 18),
            'minutes' => array(0, 30),
            'required'   => true,
            'attr' => ['class' => 'inline-time']
        ))
        ->add('firstDateEndTime', TimeType::class, array(
            'label' => 'form.availability.endTime.label',
            'widget' => 'choice',
            'hours' => range(8, 18),
            'minutes' => array(0, 30),
            'required'   => true,
            'attr' => ['class' => 'inline-time']
        ))
        ->add('secondDate', DateType::class, array(
            'label' => 'form.link.secondDate.label',
            'widget' => 'single_text',
            'html5' => true,
            'disabled' => false,
            'required'   => true,
        ))
        ->add('secondDateStartTime', TimeType::class, array(
            'label' => 'form.availability.startTime.label',
            'widget' => 'choice',
            'hours' => range(8, 18),
            'minutes' => array(0, 30),
            'disabled' => false,
            'required'   => true,
            'attr' => ['class' => 'inline-time']
        ))
        ->add('secondDateEndTime', TimeType::class, array(
            'label' => 'form.availability.endTime.label',
            'widget' => 'choice',
            'hours' => range(8, 18),
            'minutes' => array(0, 30),
            'disabled' => false,
            'required'   => true,
            'attr' => ['class' => 'inline-time']
        ))
        ->add('thirdDate', DateType::class, array(
            'label' => 'form.link.thirdDate.label',
            'widget' => 'single_text',
            'disabled' => false,
            'required'   => true,
            'html5' => true
        ))
        ->add('thirdDateStartTime', TimeType::class, array(
            'label' => 'form.availability.startTime.label',
            'widget' => 'choice',
            'hours' => range(8, 18),
            'minutes' => array(0, 30),
            'disabled' => false,
            'required'   => true,
            'attr' => ['class' => 'inline-time']
        ))
        ->add('thirdDateEndTime', TimeType::class, array(
            'label' => 'form.availability.endTime.label',
            'widget' => 'choice',
            'hours' => range(8, 18),
            'minutes' => array(0, 30),
            'disabled' => false,
            'required'   => true,
            'attr' => ['class' => 'inline-time']
        ))
    ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\MerITDLC',
            'translation_domain' => 'form',
            'validation_groups' => array(
                'add_merITDLC',
            ),
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'appbundle_merITDLC';
    }


}
