<?php

namespace AppBundle\Form\Type\Menu;

use AppBundle\Entity\Menu;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\MenuPosition;
use AppBundle\Enum\PartnerCategory;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * 
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class PartnerMenuType extends AbstractType
{
    /**
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->utils = $utils;
        $this->categories = $utils->trans(PartnerCategory::class);
    }
    
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('filter_category', ChoiceType::class, array(
                'choices' => array_flip($this->categories),
                'choice_label' => function ($choiceValue, $key, $value) {
                    return 'form.partner.category.'.$choiceValue;
                },
                'label' => 'form.partner.category.label',
                'required' => true,
            ))
            ->add('filter_support', ChoiceType::class, array(
                'choices' => array(
                    'supportUs' => 'support_us',
                    'supportThem' => 'support_them',
                ),
                'choice_label' => function ($choiceValue, $key, $value) {
                    return 'form.partner.'.$choiceValue.'.label';
                },
                'label' => 'form.partner.support.label',
                'required' => true,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            // 'data_class' => Menu::class,
            'translation_domain' => 'form',
        ));
    }
}
