<?php

namespace AppBundle\Form\Type\Menu;

use AppBundle\Entity\Menu;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\MenuPosition;
use AppBundle\Helper\MenuHelper;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * 
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class ListChildMenuType extends AbstractType
{   
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $layoutList = MenuHelper::getLayoutList('ListChild');
                
        $builder
            ->add('layout', ChoiceType::class, array(
                'choices' => $layoutList,
                'preferred_choices' => array('default.html.twig'),
                'choice_label' => function ($choiceValue, $key, $value) {
                    $tmp = str_replace('.html.twig', '', $key);
                    if($tmp == 'cols') {
                        $tmp = 'cols.default';
                    }
                    return 'form.menu.layout.'.$tmp;
                },
                'label' => 'form.menu.layout.label',
                'required' => true,
            ))
            ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            // 'data_class' => Menu::class,
            'translation_domain' => 'form',
        ));
    }
}
