<?php

namespace AppBundle\Form\Type\ITDLC;

use AppBundle\Entity\OperationITDLC;
use AppBundle\Entity\User;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\ClassroomOption;
use AppBundle\Enum\ITDLCGoalCategory;
use AppBundle\Enum\ITDLCPeriod;
use AppBundle\Enum\EmployeesInCharge;
use AppBundle\Enum\OperationITDLCState;
use AppBundle\Enum\OperationITDLCType as OperationITDLCTypeEnum;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\ChoiceList\Loader\CallbackChoiceLoader;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use AppBundle\Form\Type\MerITDLCAdminType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use AppBundle\Enum\UserType;

class OperationITDLCType extends AbstractType
{
    private $translator;
    private $utils;

    /**
     * Constructor
     * 
     * @param TranslatorInterface $translator 
     * @param ConstTranslator $utils 
     */
    public function __construct(TranslatorInterface $translator, ConstTranslator $utils)
    {
        $this->translator = $translator;
        $this->utils = $utils;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $employees = EmployeesInCharge::getConstants();
        
        $builder
            ->add('state', ChoiceType::class, [
                'label' => 'form.state.label',
                'choice_translation_domain' => 'form',
                'choices' => array_flip($this->utils->trans(OperationITDLCState::class)),
            ])
            ->add('inge', EntityType::class, [
                'choice_label' => function(User $user) {
                    return $user->getLastname() . ' ' . $user->getFirstname();
                },
                'class' => User::class,
                'label' => $this->translator->transchoice('form.engineer.label', 1, [], 'form'),
                'placeholder' => 'form.engineer.placeholder',
                'query_builder' => function(UserRepository $er) {
                    return $er->createQueryBuilder('u')
                        ->where('u.type = :type')
                        ->orderBy('u.lastname', 'ASC')
                        ->setParameter('type', UserType::ENGINEER);
                },
                'required' => false,
            ])
            ->add('prof', EntityType::class, [
                'choice_label'  => function(User $user) {
                    return $user->getLastname() . ' ' . $user->getFirstname();
                },
                'class' => User::class,
                'label' => $this->translator->transchoice('form.teacher.label', 1, [], 'form'),
                'placeholder' => 'form.teacher.placeholder',
                'query_builder' => function(UserRepository $er) {
                    return $er->createQueryBuilder('u')
                        ->where('u.type = :type')
                        ->orderBy('u.lastname', 'ASC')
                        ->setParameter('type', UserType::TEACHER);
                },
                'required'  => false,
            ])
            ->add('classLevel', ChoiceType::class, [
                'label' => 'form.itdlc.classLevel.label',
                'choices' => array_flip($this->utils->trans(ClassroomLevel::class)),
            ])
            ->add('classOption', ChoiceType::class, [
                'label' => 'form.itdlc.classOption.label',
                'required' => false,
                'choices' => array_flip($this->utils->trans(ClassroomOption::class)),
            ])
            ->add('goalCategory', ChoiceType::class, array(
                'choices' => array_flip($this->utils->trans(ITDLCGoalCategory::class)),
                'label' => 'form.itdlc.goalCategory.label',
                'required' => false,
            ))
            ->add('goal', TextareaType::class, [
                'attr' => [
                    'rows' => 5
                ],
                'label' => 'form.itdlc.goal.label',
                'required' => false,
            ])
            ->add('nbstudent', IntegerType::class, [
                'label' => 'form.itdlc.nbStudent.label',
                'required' => false,
            ])
            
            ->add('merITDLC', CollectionType::class, array(
                'entry_type' => MerITDLCAdminType::class,
                'label' => "Proposez 3 dates d'intervention",
                'allow_add' => true,
                'allow_delete' => false,
                'prototype' => true,
                'by_reference' => false,
            ))
            ->add('whoisincharge', ChoiceType::class, [
                'label' => 'form.whoisincharge.label',
                'choice_translation_domain' => 'form',
                // 'choices' => array_flip($this->utils->trans(EmployeesInCharge::class)),
                'choices' => array_flip(EmployeesInCharge::getConstants()),
                'required' => false,
            ])
            ->add('note', TextareaType::class, [
                'attr' => [
                    'rows' => 5
                ],
                'label' => 'form.notes.label',
                'required' => false,
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OperationITDLC::class,
            'translation_domain' => 'form',
            'validation_groups' => array(
                'admin_add_itdlc'
            ),
        ]);
    }
}
