<?php

namespace AppBundle\Form\Type\Front\User;

use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\EstablishmentType;
use AppBundle\Enum\EstablishmentEducation;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserJobTeacher;
use AppBundle\Enum\UserJobTeacherCategory;
use AppBundle\Enum\UserRep;
use AppBundle\Form\Type\Front\User\ProfileFormType;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use FOS\UserBundle\Form\Type\ProfileFormType as BaseProfileFormType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfileProfFormType extends ProfileFormType
{
    protected $academies;
    protected $classroomLevels;
    protected $jobsCategories;
    protected $jobs;
    protected $repLevels;
    protected $establishmentType;
    protected $establishmentEducation;
    protected $shoeSizeOptions;

    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        parent::__construct($ur, $utils);

        // $this->academies = UserHelper::getAcademyList();

        $this->classroomLevels = $utils->trans(ClassroomLevel::class);

        $this->jobsCategories = $utils->trans(UserJobTeacherCategory::class, null, null, null, true);
        
        $this->jobs = $utils->trans(UserJobTeacher::class, null, null, null, true);
        //Use legacy data
        // $jobs = UserJob::getConstants();
        // $this->jobs = array();

        // foreach ($jobs as $j) {
        //     $this->jobs[$j] = $j;
        // }

        $this->repLevels = $utils->trans(UserRep::class);
        $this->establishmentType = $utils->trans(EstablishmentType::class, null, null, null, true);
        $this->establishmentEducation = $utils->trans(EstablishmentEducation::class, null, null, null, true);

        $this->shoeSizeOptions = UserHelper::getShoeSizeOptions();
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $this->buildUserForm($builder, $options);
        $this->buildEstablishmentForm($builder, $options);
        $this->buildPasswordForm($builder, $options);
        $this->buildCommunicationForm($builder, $options);
        
        $builder 
            ->add('submit', SubmitType::class, array(
                'label' => 'form.profile.submit',
                'attr' => array(
                    'class' => 'btn btn-block btn-md btn-theme'
                ),
            ))
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildUserForm(FormBuilderInterface $builder, array $options)
    {        
        parent::buildUserForm($builder, $options);

        // @NOTE : Demande Client : Suppression Adresse personnelle - Prof : tout supprimer
        $builder->remove('personalAddress')
                ->remove('personalZipcode')
                ->remove('personalCity')
                ->remove('personalLatitude')
                ->remove('personalLongitude');
        
        $builder
            ->add('categoryJob', ChoiceType::class, array(
                'choices' => array_flip($this->jobsCategories),
                'label' => 'form.profile.teacher.jobcategory.label',
                'required' => true,
                'attr' => array(
                    'class' => 'filtering-other-field',
                    'data-field' => '#profile_prof_form_job',
                ),
            ))
            ->add('job', ChoiceType::class, array(
                'choices' => array_flip($this->jobs),
                'label' => 'form.profile.teacher.job.label',
                'required' => true,
                'attr' => array(
                    'class' => 'relationship-with-other-field'
                ),
            ))
            ->add('jobOther', TextType::class, array(
                'label' => 'form.profile.teacher.jobother.label',
                'required' => false,
            ))
            // ->add('classroom', ChoiceType::class, array(
            //     'choices' => array_flip($this->classroomLevels),
            //     'expanded' => true,
            //     'label' => 'form.profile.teacher.classroom.label',
            //     'multiple' => true,
            //     'required' => false,
            // ))
            // ->add('professionalDiscover', ChoiceType::class, array(
            //     'label' => 'form.profile.teacher.professionalDiscover.label',
            //     'choices' => array(
            //         "Oui" => true,
            //         "Non" => false
            //     ),
            //     'expanded' => true,
            // ))
            // ->add('shoeSize', ChoiceType::class, array(
            //     'choices' => $this->shoeSizeOptions,
            //     'label' => 'form.profile.shoeSize.label',
            //     'required' => false,
            // ))
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildEstablishmentForm(FormBuilderInterface $builder, array $options)
    {        
        $builder
            ->add('establishmentType', ChoiceType::class, array(
                'choices' => array_flip($this->establishmentType),
                'label' => 'form.profile.teacher.establishment.type.label',
                'required' => false,
            ))
            ->add('establishmentEducation', ChoiceType::class, array(
                'choices' => array_flip($this->establishmentEducation),
                'label' => 'form.profile.teacher.establishment.education.label',
                'required' => false,
            ))
            ->add('establishmentName', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.name.label',
                // 'required' => false,
            ))
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.address.label',
                // 'required' => false,
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.zipcode.label',
                // 'required' => false,
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.city.label', 
                // 'required' => false,
            ))
            // ->add('academy', ChoiceType::class, array(
            //     'choices' => $this->academies,
            //     'label' => 'form.profile.teacher.establishment.academy.label',
            //     'placeholder' => 'form.profile.teacher.establishment.academy.placeholder',
            //     'required' => false,
            // ))
            ->add('rep', ChoiceType::class, array(
                'choices' => array_flip($this->repLevels),
                'expanded' => true,
                'label' => 'form.profile.teacher.establishment.rep.label',
                // 'required' => false,
            ))
            // ->add('establishmentEmail', EmailType::class, array(
            //     'label' => 'form.profile.teacher.establishment.email.label',
            //     'required' => false,
            // ))
            ->add('bossEmail', EmailType::class, array(
                'label' => 'form.profile.teacher.establishment.bossEmail.label',
                'help' => 'form.profile.teacher.establishment.bossEmail.help',
                'required' => false,
            ))
            ->add('latitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('longitude', HiddenType::class, array(
                'required' => false
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
            'choice_translation_domain' => 'form',
            'validation_groups' => array(
                'profile',
                'profile_teacher'
            ),
        ));
    }
}
