<?php

namespace AppBundle\Form\Type\Front\User\Legacy;

use AppBundle\Translation\ConstTranslator;
use FOS\UserBundle\Form\Type\RegistrationFormType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserType;

class RegistrationStep1FormType extends AbstractType
{
    private $userHonorifics;

    /**
     * Constructor
     * @param ConstTranslator $utils
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->userHonorifics = $utils->trans(UserHonorific::class);
    }
    
    /**
     *
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('username', null, [
                'label' => 'form.username',
                'translation_domain' => 'FOSUserBundle',
            ])
            ->add('honorific', ChoiceType::class, [
                'choices' => array_flip($this->userHonorifics),
                'expanded' => true,
                'label' => 'form.honorific.label',
            ])
            ->add('firstname', TextType::class, [
                'label' => 'form.firstname.label',
            ])
            ->add('lastname', TextType::class, [
                'label' => 'form.lastname.label',
            ])
            ->add('email', RepeatedType::class, [
                'first_options' => ['label' => 'form.email'],
                'invalid_message' => "Les adresses e-mail ne correspondent pas.",
                'options' => [
                    'translation_domain' => 'FOSUserBundle',
                ],
                'second_options' => ['label' => 'form.email_confirmation'],
                'type' => EmailType::class,
            ])
            ->add('plainPassword', RepeatedType::class, [
                'type' => PasswordType::class,
                'options' => [
                    'translation_domain' => 'FOSUserBundle',
                ],
                'first_options' => ['label' => 'form.password'],
                'second_options' => ['label' => 'form.password_confirmation'],
                'invalid_message' => 'fos_user.password.mismatch',
            ])
            ->add('birthday', DateType::class, [
                'label' => 'form.date.birth.label',
                'required' => false,
                'years' => range(date('Y'), '1900'),
            ])
            ->add('phone', TextType::class, [
                'label' => 'form.phone.landline.label',
            ])
            ->add('mobile', TextType::class, array_merge([
                'label' => 'form.phone.mobile.label',
                'required' => false,
            ], UserType::TEACHER === $options['data']->getType()
                ? ['help' => 'Merci de renseigner ce champs pour que nous puissions vous envoyer vos convocations par SMS']
                : []
            ))
            ->add('submit', SubmitType::class, [
                'label' => 'registration.next_step',
                'translation_domain' => 'FOSUserBundle',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ])
        ;
    }

    /**
     *
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'translation_domain' => 'form',
            'validation_groups' => [
                'Registration',
                'registration_step1',
            ]
        ]);
    }

    /**
     * 
     * @return string
     */
    public function getParent(): string
    {
        return RegistrationFormType::class;
    }
}
