<?php

namespace AppBundle\Form\Type\Front\PEE;

use AppBundle\Entity\User;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\UserJobTeacher;
use AppBundle\Enum\UserJobTeacherCategory;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfDemandePEEStep1Type extends AbstractType
{
    protected $classroomLevels;
    protected $jobsCategories;
    protected $jobs;

    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        
        $this->classroomLevels = $utils->trans(ClassroomLevel::class);
        $this->jobsCategories = $utils->trans(UserJobTeacherCategory::class, null, null, null, true);
        $this->jobs = $utils->trans(UserJobTeacher::class, null, null, null, true);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {        
        $builder 
            ->add('mobile', TextType::class, array(
                'help' => 'form.profile.mobile.help', 
                'label' => 'form.profile.mobile.label',
                //'required' => false,
            ))
            // @NOTE : Demande Client : Suppression Adresse personnelle - Prof : tout supprimer
            // ->add('personalAddress', TextType::class, array(
            //     'label' => 'form.profile.personaladdress.address.label',
            //     // 'required' => false,
            // ))
            // ->add('personalCity', TextType::class, array(
            //     'label' => 'form.profile.personaladdress.city.label',
            //     // 'required' => false,
            // ))
            // ->add('personalZipcode', TextType::class, array(
            //     'label' => 'form.profile.personaladdress.zipcode.label',
            //     // 'required' => false,
            // ))
            // ->add('personalLatitude', HiddenType::class, array(
            //     'required' => false
            // ))
            // ->add('personalLongitude', HiddenType::class, array(
            //     'required' => false
            // ))
            ->add('categoryJob', ChoiceType::class, array(
                'choices' => array_flip($this->jobsCategories),
                'label' => 'form.profile.teacher.jobcategory.label',
                // 'required' => false,
                'attr' => array(
                    'class' => 'filtering-other-field',
                    'data-field' => '#prof_demande_pee_step1_job',
                ),
            ))
            ->add('job', ChoiceType::class, array(
                'choices' => array_flip($this->jobs),
                'label' => 'form.profile.teacher.job.label',
                // 'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field'
                ),
            ))
            ->add('jobOther', TextType::class, array(
                'label' => 'form.profile.teacher.jobother.label',
                'required' => false,
            ))
            // ->add('classroom', ChoiceType::class, array(
            //     'choices' => array_flip($this->classroomLevels),
            //     'expanded' => true,
            //     'label' => 'form.profile.teacher.classroom.label',
            //     'multiple' => true,
            //     'required' => false,
            // ))
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.pee.next',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
            'translation_domain' => 'form',
            'choice_translation_domain' => 'form',
            'validation_groups' => array(
                'add_pee_step1',
                'add_pee_teacher_step1',
            ),
        ));
    }
}
