<?php

namespace AppBundle\Form\Type\Front\PEE\Legacy;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use AppBundle\Entity\User;

class UserDemandePEEType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user_id = $options['data']->getId();
        $pointures = array('' => '');
        for ($i = 33; $i <= 50 ; $i++) {
            $pointures[$i] = $i;
        }

        $builder
            ->add('expectations', TextareaType::class, [
                'attr' => [
                    'rows' => 8,
                ],
                'label' => 'form.expectations.label',
                'required' => false,
            ])
            ->add('shoeSize', ChoiceType::class, array(
                'choices' => $pointures,
                'label' => 'form.shoeSize.label',
            ))
            ->add('sendCard', ChoiceType::class, array(
                'choices' =>  array(
                    "Envoi électronique" => 'digitale',
                    "Envoi postal" => 'postale',
                ),
                'expanded' => true,
                'label' => 'Pièce dʼidentité',
            ))
            ->add('file', FileType::class, array(
                'attr' => array(
                    'class' => 'file_input',
                    'data-user-id' => $user_id,
                    'data-card-number' => 1
                ),
                'image_path' => 'IdentityCard1',
                'label' => 'Recto',
                'required' => false,
            ))
            ->add('fileDocument', FileType::class, array(
                'attr' => array(
                    'class' => 'file_input',
                    'data-user-id' => $user_id,
                    'data-card-number' => 2
                ),
                'image_path' => 'IdentityCard2',
                'label' => 'Verso',
                'required' => false,
            ))
            ->add('photograph', ChoiceType::class, array(
                'choices' => array(
                    "Oui, j'accepte" => 1,
                    "Non, je refuse" => 0
                ),
                'choice_value' => function ($currentChoiceKey) { // L'utilisation de cette fonction anonyme est rendue nécessaire par un bug de Symfony : https://github.com/symfony/symfony/issues/14712#issuecomment-112360074
                    return $currentChoiceKey ? 'true' : 'false';
                },
                'expanded' => true,
                'label' => false,
            ))
            ->add('submit', SubmitType::class, array(
                'label' => 'action.save',
                'translation_domain' => 'action',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ))
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
            'translation_domain' => 'form',
            'validation_groups' => array('add_pee')
        ));
    }
}
