<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Availability;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AvailabilityHebdoType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $week = array_flip(array(
            'Lundi' => 'word.days.monday.label',
            'Mardi' => 'word.days.tuesday.label',
            'Mercredi' => 'word.days.wednesday.label',
            'Jeudi' => 'word.days.thursday.label',
            'Vendredi' => 'word.days.friday.label',
            // 'Samedi' => 'word.days.saturday.label',
            // 'Dimanche' => 'word.days.sunday.label',
        ));

        $builder
            ->add('dayoftheweek', ChoiceType::class, array(
                'choices' => $week,
                'choice_translation_domain' => 'word',
                'label' => 'word.days.label',
                'translation_domain' => 'word',
                'attr' => array('class' => 'with-border'),
            ))
            ->add('startTime', TimeType::class, array(
                'label' => 'form.availability.startTime.label',
                'widget' => 'choice',
                'hours' => range(8, 18),
                'minutes' => array(0, 30),
                'attr' => array('class' => 'time with-border'),
            ))
            ->add('endTime', TimeType::class, array(
                'label' => 'form.availability.endTime.label',
                'widget' => 'choice',
                'hours' => range(8, 18),
                'minutes' => array(0, 30),
                'attr' => array('class' => 'time with-border'),
            ))
            ->add('submit', SubmitType::class, [
                'label' => 'action.add.availability.weekly',
                'translation_domain' => 'action',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Availability::class,
            'translation_domain' => 'form',
        ));
    }
}
