<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Content;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ActuContentType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $isModule = $options['data']->getIsModule();
        $isMain = $options['data']->getIsMain();
        $isActu = $options['data']->getIsActu();
        $isModule = $options['data']->getIsModule();
        $isMain = $options['data']->getIsMain();
        $isActu = $options['data']->getIsActu();

        $typeMeta = ($isMain || $isActu) ? TextType::class : HiddenType::class;

        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.title.label',
            ))
            ->add('created', DateType::class, array(
                'attr' => array('class' => 'date'),
                'format' => 'dd/MM/yyyy',
                'label' => 'form.date.creation.label',
                'required' => false,
                'widget' => 'single_text',
            ))
            ->add('publish', DateType::class, array(
                'attr' => array('class' => 'date'),
                'format' => 'dd/MM/yyyy',
                'label' => 'form.date.publish.label',
                'required' => false,
                'widget' => 'single_text',
            ))
            ->add('unpublish', DateType::class, array(
                'attr' => array('class' => 'date'),
                'format' => 'dd/MM/yyyy',
                'label' => 'form.date.unpublish.label',
                'required' => false,
                'widget' => 'single_text',
            ))
            ->add('file', FileType::class, array(
                'attr' => array(
                    'class' => 'image_input',
                ),
                'help' => 'Dimensions idéales: 148x148',
                'image_path' => 'webPicture',
                'label' => 'form.picture.label',
                'required' => false,
            ))
            ->add('article', TextareaType::class, array(
                'attr' => array('class' => 'tinymce'),
                'label' => 'form.description.label',
                'required' => false,
            ))
            ->add('menu', EntityType::class, array('class' => 'AppBundle:Menu',
                'choice_label'  => 'title',
                'expanded'  => false,
                'label' => 'Emplacement',
                'multiple'  => false,
                'placeholder' => '',
                'query_builder' => function(EntityRepository $er) {
                    return $er->createQueryBuilder('m')
                        ->where('m.typeTemplate=:type')
                        ->setParameter('type' , '7')
                        ->orderBy('m.position', 'ASC');
                },
            ))
            ->add('featured', CheckboxType::class, array(
                'label' => 'Article à la une',
                'required' => false,
            ))
            ->add('position', NumberType::class, array(
                'label' => 'form.position.label',
                'required' => false,
            ))
            ->add('is_active', CheckboxType::class, array(
                'label' => 'Active',
                'required' => false,
            ))
            ->add('is_module', HiddenType::class, array(
                'data' => $isModule,
            ))
            ->add('is_main', HiddenType::class, array(
                'data' => $isMain,
            ))
            ->add('is_actu', HiddenType::class, array(
                'data' => $isActu,
            ))
            ->add('metatitle', $typeMeta, array(
                'label' => 'form.meta.title.label',
                'required' => false,
            ))
            ->add('metadescription', $typeMeta, array(
                'label' => 'form.meta.description.label',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Content::class,
            'translation_domain' => 'form',
        ));
    }
}
