<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

/**
 * OperationPEECategory
 *
 * @ORM\Table(name="operationpee_category")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\OperationPEECategoryRepository")
 * @Vich\Uploadable
 */
class OperationPEECategory
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, unique=true)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="logo_path", type="string", length=255, nullable=true)
     */
    private $logoPath;

    /**
     * @var int
     *
     * @ORM\Column(name="logo_size", type="integer", nullable=true)
     */
    protected $logoSize;

    /**
     * @var File
     * 
     * @Vich\UploadableField(mapping="operationpee_category_logo", fileNameProperty="logoPath", size="logoSize")
     */
    protected $logoFile;

    /**
     * @var bool
     *
     * @ORM\Column(name="is_active", type="boolean", nullable=false)
     */
    private $isActive = true;

    /**
     * @ORM\OneToMany(targetEntity="OperationPEE", mappedBy="category", fetch="EXTRA_LAZY")
     */
    private $peeOperations;

    /**
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\User", mappedBy="establishmentSector", fetch="EXTRA_LAZY")
     */
    protected $users;

     /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="Company", mappedBy="companyCategory", fetch="EXTRA_LAZY")
     */
    private $companies;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTime
     */
    protected $createdAt;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTime
     */
    protected $updatedAt;
    

    public function __construct()
    {
        $this->peeOperations = new ArrayCollection();
    }

    public function __toString()
    {
        return $this->getName();
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return OperationPEECategory
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set logoFile
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile $logoFile
     *
     * @return OperationPEECategory
     */
    public function setLogoFile(File $logoFile = null)
    {
        $this->logoFile = $logoFile;

        if ($logoFile) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }

        return $this;
    }

    /**
     * Get logoFile
     *
     * @return File|null
     */
    public function getLogoFile()
    {
        return $this->logoFile;
    }

    /**
     * Set logoPath
     *
     * @param string $logoPath
     *
     * @return OperationPEECategory
     */
    public function setLogoPath($logoPath)
    {
        $this->logoPath = $logoPath;

        return $this;
    }

    /**
     * Get logoPath
     *
     * @return string
     */
    public function getLogoPath()
    {
        return $this->logoPath;
    }

    /**
     * Set logoSize
     *
     * @param int $logoSize
     *
     * @return OperationPEECategory
     */
    public function setLogoSize($logoSize)
    {
        $this->logoSize = $logoSize;

        return $this;
    }

    /**
     * Get logoSize
     *
     * @return int
     */
    public function getLogoSize()
    {
        return $this->logoSize;
    }

    /**
     * Set isActive.
     *
     * @param bool $isActive
     *
     * @return Module
     */
    public function setIsActive($isActive)
    {
        $this->isActive = $isActive;

        return $this;
    }

    /**
     * Get isActive.
     *
     * @return bool
     */
    public function getIsActive()
    {
        return $this->isActive;
    }

    /**
     * Add OperationPEE
     *
     * @param OperationPEE $peeOperation
     * 
     * @return OperationPEECategory
     */
    public function addPeeOperation(OperationPEE $peeOperation)
    {
        $this->peeOperations[] = $peeOperation;

        return $this;
    }

    /**
     * Remove peeOperation
     *
     * @param OperationPEE $peeOperation
     */
    public function removePeeOperation(OperationPEE $peeOperation)
    {
        $this->peeOperations->removeElement($peeOperation);
    }

    /**
     * Get peeOperations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPeeOperations()
    {
        return $this->peeOperations;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     *
     * @return OperationPEECategory
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     *
     * @return OperationPEECategory
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     *
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function updatedTimestamps()
    {
        $this->setUpdatedAt(new \DateTimeImmutable());

        if (!$this->getCreatedAt()) {
            $this->setCreatedAt(new \DateTimeImmutable());
        }
    }

    /**
     * Indicates if an establishment can be deleted.
     * This method takes advantages of the fetch="EXTRA_LAZY" Doctrine annotation, using only count() on ArrayCollection.
     * @see http://docs.doctrine-project.org/projects/doctrine-orm/en/latest/tutorials/extra-lazy-associations.html Extra Lazy Associations
     * @return boolean 
     */
    public function isDeletable()
    {
        return 0 === $this->getPeeOperations()->count();
    }
}

