<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MenuMedia
 *
 * @ORM\Table(name="menu_media")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\MenuMediaRepository")
 */
class MenuMedia
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="position", type="integer")
     */
    private $position;

    /**
     * @ORM\ManyToOne(targetEntity="Menu", inversedBy="menumedias")
     * @ORM\JoinColumn(name="menu", referencedColumnName="id", nullable=false)
     */
    private $menu;

    /**
     * @ORM\ManyToOne(targetEntity="Media", inversedBy="menumedias")
     * @ORM\JoinColumn(name="media", referencedColumnName="id", nullable=false)
     */
    private $media;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set media
     * @param Media $media
     * @return MenuMedia
     */
    public function setMedia(Media $media = null)
    {
        $this->media = $media;

        return $this;
    }

    /**
     * Get media
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMedia()
    {
        return $this->media;
    }

    /**
     * Set menu
     * @param Menu $menu
     * @return MenuMedia
     */
    public function setMenu(Menu $menu = null)
    {
        $this->menu = $menu;

        return $this;
    }

    /**
     * Get menu
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMenu()
    {
        return $this->menu;
    }

    /**
     * Set position
     *
     * @param int $position
     * @return MenuMedia
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * Get position
     *
     * @return integer
     */
    public function getPosition()
    {
        return $this->position;
    }
}
