<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="Availability")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks
 */
class Availability
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime $dateVisite
     *
     * @ORM\Column(name="dateVisite", type="date", nullable=true)
     */
    private $dateVisite;

    /**
     * @var \DateTime $startTime
     *
     * @ORM\Column(name="startTime", type="time", nullable=true)
     */
    private $startTime;

    /**
     * @var \DateTime $endTime
     *
     * @ORM\Column(name="endTime", type="time", nullable=true)
     */
    private $endTime;

    /**
     * @var string $dayoftheweek
     *
     * @ORM\Column(name="dayoftheweek", type="string", length=50, nullable=true)
     */
    private $dayoftheweek;

    /**
     * @var OperationITDLC $operationitdlc
     *
     * @ORM\ManyToOne(targetEntity="OperationITDLC", inversedBy="availability")
     * @ORM\JoinColumn(name="operationitdlc", referencedColumnName="id", nullable=false)
     */
    private $operationitdlc;


    /**
    * Get id
    *
    * @return integer
    */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dateVisite
     *
     * @param \DateTime $dateVisite
     * 
     * @return Availability
     */
    public function setDateVisite($dateVisite)
    {
        $this->dateVisite = $dateVisite;

        return $this;
    }

    /**
     * Get dateVisite
     *
     * @return \DateTime
     */
    public function getDateVisite()
    {
        return $this->dateVisite;
    }

    /**
     * Set startTime
     *
     * @param \DateTime $startTime
     * 
     * @return Availability
     */
    public function setStartTime($startTime)
    {
        $this->startTime = $startTime;

        return $this;
    }

    /**
     * Get startTime
     *
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->startTime;
    }

    /**
     * Set endTime
     *
     * @param \DateTime $endTime
     * 
     * @return Availability
     */
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;

        return $this;
    }

    /**
     * Get endTime
     *
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * Set dayoftheweek
     *
     * @param string $dayoftheweek
     * 
     * @return Availability
     */
    public function setDayoftheweek($dayoftheweek)
    {
        $this->dayoftheweek = $dayoftheweek;

        return $this;
    }

    /**
     * Get dayoftheweek
     *
     * @return string
     */
    public function getDayoftheweek()
    {
        return $this->dayoftheweek;
    }

    /**
     * Set operationitdlc
     *
     * @param OperationITDLC $operationitdlc
     * 
     * @return Availability
     */
    public function setOperationitdlc(OperationITDLC $operationitdlc)
    {
        $this->operationitdlc = $operationitdlc;

        return $this;
    }

    /**
     * Get operationitdlc
     *
     * @return OperationITDLC
     */
    public function getOperationitdlc()
    {
        return $this->operationitdlc;
    }
}
