<?php

namespace AppBundle\Controller\Module;

use AppBundle\Controller\ModuleController;
use AppBundle\Entity\Media;
use AppBundle\Entity\Menu;
use AppBundle\Entity\Module;
use AppBundle\Enum\MediaType;
use AppBundle\Enum\UserType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;

class PicturesListController extends ModuleController
{
    /**
     * @param Int $moduleId Défini le module à afficher
     * @param string $force_layout Définit le type de rendu Twig souhaité
     * @param Int $menuId Défini le menu associé, la page actuelle qui demande l'affichage
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function renderModule(Int $moduleId, string $force_layout = null, Int $menuId = null)
    {
        $module = $this->em->getRepository(Module::class)->findOneBy([
            'isActive' => true, 
            'id' => $moduleId
        ]);
        
        if (empty($module)) {
            return new Response('');
        }

        //Force layout
        if (!empty($force_layout)) {
            $module->setLayout($force_layout);
        }
        
        $module->setFormClass($module->getType());
        $layout = $module->getLayoutPath();

        //Check if layout is correct
        if (!empty($force_layout) && strpos($layout, $force_layout) === false) {
            return new Response('');
        }

        //Custom request here
        $auto = (int) $module->getParams()->auto_items;

        if ($auto && $menuId) { 
            //Mode auto
            $menu = $this->em->getRepository(Menu::class)->find($menuId);           
            $pictures = $this->em->getRepository(Media::class)->findByMenu(
            $menu->getId(),
            [
                'is_active' => true,
                'type' => MediaType::PICTURE
            ]);
        }
        else {
            //Mode Selected
            $listIds = (array) $module->getParams()->items;
            $pictures = $this->em->getRepository(Media::class)->findBy([
                'id' => $listIds,
                'is_active' => true,
                'type' => MediaType::PICTURE
            ], 
            ['title' => 'ASC', 'id' => 'ASC']);
        }

        if (empty($pictures)) {
            return new Response('');
        }

        // Specific to layout cols.html.twig
        switch ( count($pictures) ) {
            case 1 :
            case 2 :
            case 3 :
                    $itemClass = "col-md-6 col-lg-4";
                    break;
            case 4 : 
            default:
                    $itemClass = "col-md-6 col-lg-3";
                    break;
        }

        return $this->render($layout , array(
            'module' => $module, 
            'medias' => $pictures,
            'itemcol' => $itemClass,
        ));
    }
}
