<?php

namespace AppBundle\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class DefaultController extends Controller
{
    /**
     * @var EntityManagerInterface
     */
    private $em;
    
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * Affiche la page d'accueil
     *
     * @Route(
     *      "/",
     *      name = "_welcome"
     * )
     */
    public function indexAction()
    {
        return $this->render('Front/Default/index.html.twig');
    }

    /**
     * Affiche la page d'accueil
     *
     * @Route(
     *      "/gui/{bodyClass}",
     *      defaults={"bodyClass": "default"},
     *      requirements={
     *         "bodyClass": "default|tangerine|la-rioja|pelorous|tundora"
     *      },
     *      name = "_gui"
     * )
     */
    public function guiAction($bodyClass)
    {
        if ($bodyClass == 'default') {
            $bodyClass = "gui";
        }
        
        return $this->render('Front/Default/gui.html.twig', array(
            'bodyClass' => $bodyClass, 
        ));
    }
}
