<?php

namespace AppBundle\Command;

use AppBundle\Entity\Contact;
use AppBundle\Entity\Content;
use AppBundle\Entity\Menu;
use AppBundle\Entity\Testimonial;
use AppBundle\Enum\MediaType;
use AppBundle\Enum\TypeTemplateTitle;
use AppBundle\Helper\MenuHelper;
use Cocur\Slugify\Slugify;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Routing\RouterInterface;

class SEOGenerate301Command extends ContainerAwareCommand
{
    /**
     * @var RouterInterface
     */
    protected $router;
    
    protected function configure()
    {
        $this
            ->setName('cgenial:migrations:seo301')
            ->setDescription('Generate redirections 301 for Article Content')
        ;
    }

    public function __construct(RouterInterface $router)
    {
        $this->router = $router;
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get("doctrine.orm.entity_manager");
        // $articles = $em->getRepository('AppBundle:Content')->findBy(
        //     array(
        //         'is_active' => true,
        //         'is_actu' => true
        //     ),
        //     array(
        //         'position' => 'ASC',
        //         'id' => 'ASC',
        //     )
        // );

        $menus = $em->getRepository('AppBundle:Menu')->findBy(
            array(
                'is_active' => true
            ),
            array(
                'typeTemplate' => 'ASC',
                'parent' => 'ASC',
                'position' => 'ASC',
                'id' => 'ASC',
            )
        );

        $domain = $this->getContainer()->getParameter('cgenial.domain');
        $slugify = new Slugify();
        
        $output->writeln("--------------------------------------------------------");
        // if (!empty($articles)) {
        //     foreach($articles as $article) {
        //         $menu = $article->getMenu();
        //         $parent = $menu->getParent();

        //         $routeParams = array();

        //         $_route = 'template';
        //         $routeParams['id'] = $article->getId();
        //         $routeParams['title'] = $slugify->slugify($article->getTitle());

        //         if (!empty($menu)) {
        //             $_route = 'template_level2';
        //             $routeParams['idlevel1'] = $menu->getId();
        //             $routeParams['titlelevel1'] = $menu->getSlug();

        //             if (!empty($parent)) {
        //                 $_route = 'template_level3';
        //                 $routeParams['idlevel1'] = $parent->getId();
        //                 $routeParams['titlelevel1'] = $parent->getSlug();
        //                 $routeParams['idlevel2'] = $menu->getId();
        //                 $routeParams['titlelevel2'] = $menu->getSlug();
        //             }
        //         }

        //         $urlNew = $this->router->generate($_route, $routeParams);
        //         $urlOld = "";
        //         if (trim($urlOld, '/') !== trim($urlNew, '/')) {
        //             $output->writeln("RewriteRule ^" . trim($urlOld, '/') . "/?$ " . $urlNew . " [L,R=301]");
        //         }
        //     }
        // } else {
        //     $output->writeln('0 article found');
        // }
        // $output->writeln("--------------------------------------------------------");

        if (!empty($menus)) {
            foreach($menus as $menu) {
                $redirect = false;
                $menuId = $menu->getId();
                $parent = $menu->getParent();

                $tplTitle = $menu->getTypeTemplate()->getTitle();

                if (TypeTemplateTitle::NEWS === $tplTitle) {
                    $redirect = true;
                    $routeParams = array();

                    $_route = 'list_actu';
                    $routeParams['catid'] = $menu->getId();
                    $routeParams['catslug'] = $menu->getSlug();

                    if (!empty($parent)) {
                        $routeParams['id'] = $parent->getId();
                        $routeParams['slug'] = $parent->getSlug();
                    }

                    $urlNew = $this->router->generate($_route, $routeParams);
                    $urlOld = "/actualites/55-actualites/".$menu->getId();
                }
                elseif (TypeTemplateTitle::MEDIA === $tplTitle) {
                    $redirect = true;
                    $routeParams = array();

                    $_route = 'list_media';
                    $routeParams['catid'] = $menu->getId();
                    $routeParams['catslug'] = $menu->getSlug();

                    if (!empty($parent)) {
                        $routeParams['id'] = $parent->getId();
                        $routeParams['slug'] = $parent->getSlug();
                    }

                    $urlNew = $this->router->generate($_route, $routeParams);
                    $urlOld = "/media/70-cgenial-tv/".$menu->getId();
                }
                elseif (TypeTemplateTitle::LIST_CHILD === $tplTitle) {
                    $redirect = true;
                    
                    // Redirect 1
                    $routeParams = array();

                    $_route = 'template';
                    $routeParams['id'] = $menu->getId();
                    $routeParams['title'] = $menu->getSlug();

                    if (!empty($parent)) {
                        $_route = 'template_level2';
                        $routeParams['idlevel1'] = $parent->getId();
                        $routeParams['titlelevel1'] = $parent->getSlug();
                    }

                    $urlNew = $this->router->generate($_route, $routeParams);

                    if ($menuId === 55) {
                        $routeParams['title'] = "actualites";
                    }

                    $urlOld = "/" . $routeParams['id'] . "-" . $routeParams['title'];

                    if ($redirect && trim($urlOld, '/') !== trim($urlNew, '/')) {
                        $output->writeln("RewriteRule ^" . trim($urlOld, '/') . "/?$ " . $urlNew . " [L,R=301]");
                    }

                    // Redirect 2
                    $routeParams = array();

                    $child = $menu->getChildren()->first();
                    $tplTitleChild = $menu->getTypeTemplate()->getTitle();

                    if (TypeTemplateTitle::NEWS === $tplTitleChild) {
                        $_route = 'list_actu';
                        $routeParams['catid'] = $child->getId();
                        $routeParams['catslug'] = $child->getSlug();
                        $routeParams['id'] = $menu->getId();
                        $routeParams['slug'] = $menu->getSlug();
                        
                    } elseif (TypeTemplateTitle::MEDIA === $tplTitle) {
                        $_route = 'list_media';
                        $routeParams['catid'] = $child->getId();
                        $routeParams['catslug'] = $child->getSlug();
                        $routeParams['id'] = $menu->getId();
                        $routeParams['slug'] = $menu->getSlug();
                    }
                    else {
                        continue;
                    }

                    $urlNew = $this->router->generate($_route, $routeParams);
                    $urlOld = str_replace("0-All", "All", $urlNew);
                }

                if ($redirect && trim($urlOld, '/') !== trim($urlNew, '/')) {
                    $output->writeln("RewriteRule ^" . trim($urlOld, '/') . "/?$ " . $urlNew . " [L,R=301]");
                }
                
            }
        } else {
            $output->writeln('0 article found');
        }
        $output->writeln("--------------------------------------------------------");
    }

}
