<?php

namespace AppBundle\Command;

use AppBundle\Entity\MerHistoryITDLC;
use AppBundle\Entity\MerITDLC;
use AppBundle\Entity\OperationITDLC;
use AppBundle\Enum\OperationITDLCState;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use AppBundle\Mail\ItdlcMailer;

class RemindersMerITDLCCommand extends ContainerAwareCommand
{

    protected function configure()
    {
        $this
            ->setName('cgenial:reminders')
            ->setDescription("Send reminders email")
            ->addArgument('type', InputArgument::REQUIRED, '5j => engineer MER, 10j => teacher search a new engineer,  7j => teacher and engineer operation is coming, 30j => teacher without MER')// ->addOption('option', null, InputOption::VALUE_NONE, 'Option description')
        ;

        setlocale(LC_ALL, 'fr_FR');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $type = $input->getArgument('type');
        $em = $this->getContainer()->get("doctrine.orm.entity_manager");
        $idtlcMailer = $this->getContainer()->get("AppBundle\\Mail\\ItdlcMailer");

        $output->writeln("--------------------------------------------------------");

        if ($type == "5j") {
            $mers = $em->getRepository(MerITDLC::class)->getMerWithoutAnswer();

            if (!empty($mers)) {
                foreach ($mers as $mer) {
                    $reponse = $idtlcMailer->sendReminderMerToInge($mer);

                    if (!empty($reponse[0]) && $reponse[0]['code'] == "success") {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent to ' . $mer->getInge()->getEmail() . " (" . $mer->getInge()->getFullName() . ") => IDTLC: " . $mer->getOpe()->getId());
                        $mer->setReminderAt();

                        $merHistory = new MerHistoryITDLC();
                        $merHistory->setInfos("Envoi d'un rappel à " . $mer->getInge()->getFullName());
                        $mer->addHistory($merHistory);

                        $em->persist($mer);
                    } else {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Error email didn\t send to ' . $mer->getInge()->getEmail() . " (" . $mer->getInge()->getFullName() . ") => IDTLC: " . $mer->getOpe()->getId());
                    }
                }

                $em->flush();
            } else {
                $output->writeln("[" . date('d/m/Y H:i:s') . "] " . '0 reminder to send');
            }

        } else if ($type == "7j") {

            $opes = $em->getRepository(OperationITDLC::class)->findComingSoonOperations();

            if (!empty($opes)) {
                foreach ($opes as $ope) {
                    $reponses = $idtlcMailer->sendReminderComingSoonOperation($ope);

                    if (!empty($reponses[0][0]) && $reponses[0][0]['code'] == "success") {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent to ' . $ope->getProf()->getEmail() . " (" . $ope->getProf()->getFullName() . ") => IDTLC: " . $ope->getId());

                    } else {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Error email didn\t send to ' . $ope->getProf()->getEmail() . " (" . $ope->getProf()->getFullName() . ") => IDTLC: " . $ope->getId());
                    }

                    if (!empty($reponses[1][0]) && $reponses[1][0]['code'] == "success") {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent to ' . $ope->getInge()->getEmail() . " (" . $ope->getInge()->getFullName() . ") => IDTLC: " . $ope->getId());

                    } else {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Error email didn\t send to ' . $ope->getInge()->getEmail() . " (" . $ope->getInge()->getFullName() . ") => IDTLC: " . $ope->getId());
                    }
                }

                $em->flush();
            } else {
                $output->writeln("[" . date('d/m/Y H:i:s') . "] " . '0 reminder to send');
            }
        } else if ($type == "10j") {

            $mers = $em->getRepository(MerITDLC::class)->getMerWithoutAnswerAfterReminders();

            if (!empty($mers)) {
                foreach ($mers as $mer) {
                    $reponse = $idtlcMailer->sendReminderMerToTeacher($mer);

                    if (!empty($reponse[0]) && $reponse[0]['code'] == "success") {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent to ' . $mer->getOpe()->getProf()->getEmail() . " (" . $mer->getOpe()->getProf()->getFullName() . ") => IDTLC: " . $mer->getOpe()->getId());
                        $ope = $mer->getOpe();
                        $inge = $ope->getInge();
                        $numNoAnswer = intval($inge->getNumberNoAnswer()) + 1;
                        $inge->setNumberNoAnswer($numNoAnswer);
                        $em->persist($inge);

                        $ope->setInge(null);
                        $ope->setState(OperationITDLCState::NEW);
                        $em->persist($ope);

                        $merHistory = new MerHistoryITDLC();
                        $merHistory->setInfos("Aucune réponse à votre proposition depuis 10 jours de " . $mer->getInge()->getFullName());
                        $mer->addHistory($merHistory);

                        $em->persist($mer);
                    } else {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Error email didn\t send to ' . $mer->getOpe()->getProf()->getEmail() . " (" . $mer->getOpe()->getProf()->getFullName() . ") => IDTLC: " . $mer->getOpe()->getId());
                    }
                }

                $em->flush();
            } else {
                $output->writeln("[" . date('d/m/Y H:i:s') . "] " . '0 reminder to send');
            }


        } else if ($type == "30j") {

            $opes = $em->getRepository(OperationITDLC::class)->findDemandeWithoutMer();

            if (!empty($opes)) {
                foreach ($opes as $ope) {
                    $reponse = $idtlcMailer->sendOperationNoMerToTeacher($ope);

                    if (!empty($reponse[0]) && $reponse[0]['code'] == "success") {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent to ' . $ope->getProf()->getEmail() . " (" . $ope->getProf()->getFullName() . ") => IDTLC: " . $ope->getId());
                    } else {
                        $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Error email didn\t send to ' . $ope->getProf()->getEmail() . " (" . $ope->getProf()->getFullName() . ") => IDTLC: " . $ope->getId());
                    }
                }
            } else {
                $output->writeln("[" . date('d/m/Y H:i:s') . "] " . '0 reminder to send');
            }
        }

        $output->writeln("--------------------------------------------------------");
    }

}
