<?php

namespace AppBundle\Command;

use AppBundle\Entity\User;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DesactivateEngineerCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('cgenial:desactivate:engineers')
            ->setDescription('Desactivate engineers with 2 no answer')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get("doctrine.orm.entity_manager");
        $users = $em->getRepository(User::class)->findAllUsersToBeDesactivate();
        $output->writeln("--------------------------------------------------------");
        if (!empty($users)) {
            foreach($users as $user) {
                $output->writeln("[" . date('d/m/Y H:i:s') . "] user ".$user['id']. (!empty($user['firstname']) ? " (". $user['firstname'] ." ".$user['lastname']. ")" : "")." desactivated");
            }

            $update = $em->getRepository(User::class)->desactivateEngineerWith2NoAnswer();

            $output->writeln("[" . date('d/m/Y H:i:s') . "] Update ".($update == count($users) ? "successful": "failed"));

        } else {
            $output->writeln("[" . date('d/m/Y H:i:s') . "] 0 user desactivated.");
        }

         $output->writeln("--------------------------------------------------------");
    }

}
