/**
 * Functions related to Symfony collections.
 * @see http://symfony.com/doc/current/cookbook/form/form_collections.html
 */

/**
 * Add an item to the collection according to the item prototype
 * @param {object} $collection
 */
function addItem($collection)
{
    var $item = $($collection.attr('data-prototype').replace(/__name__/g, $collection.children().length));

    $collection.append($item);

    $item.fadeIn();
}
    
$(function () {
    var $collections = $('.form-collection');

    // Add a click event on the add item
    $('.form-collection--add').on('click', function (e) {
        e.preventDefault();

        // The collection is the previous element in the DOM
        addItem($(this).prev('.form-collection'));
    });

    // The deletion is handled by the behaviors bind on .delete-element (see main.js)
});
