<?php declare(strict_types=1);

namespace Application\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180709203739 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');
        
        $this->addSql('CREATE SEQUENCE IF NOT EXISTS module_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE IF NOT EXISTS module (id INT NOT NULL, position VARCHAR(255) DEFAULT NULL, type VARCHAR(255) NOT NULL, title VARCHAR(255) NOT NULL, picture VARCHAR(255) DEFAULT NULL, params TEXT NOT NULL, layout VARCHAR(255) NOT NULL, custom_class VARCHAR(255) DEFAULT NULL, ordering INT NOT NULL, is_active BOOLEAN NOT NULL, created TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, updated TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('COMMENT ON COLUMN module.params IS \'(DC2Type:object)\'');
        $this->addSql('CREATE TABLE IF NOT EXISTS module_menu (module_id INT NOT NULL, menu_id INT NOT NULL, PRIMARY KEY(module_id, menu_id))');
        $this->addSql('CREATE INDEX IF NOT EXISTS IDX_C7397F9FAFC2B591 ON module_menu (module_id)');
        $this->addSql('CREATE INDEX IF NOT EXISTS IDX_C7397F9FCCD7E912 ON module_menu (menu_id)');
        $this->addSql('ALTER TABLE module_menu DROP CONSTRAINT IF EXISTS FK_C7397F9FAFC2B591');
        $this->addSql('ALTER TABLE module_menu ADD CONSTRAINT FK_C7397F9FAFC2B591 FOREIGN KEY (module_id) REFERENCES module (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE module_menu DROP CONSTRAINT IF EXISTS FK_C7397F9FCCD7E912');
        $this->addSql('ALTER TABLE module_menu ADD CONSTRAINT FK_C7397F9FCCD7E912 FOREIGN KEY (menu_id) REFERENCES Menu (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE establishment ALTER available_for_users DROP NOT NULL');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('DROP SEQUENCE module_id_seq CASCADE');
        $this->addSql('DROP TABLE module CASCADE');
        $this->addSql('DROP TABLE module_menu CASCADE');
    }
}
