<?php

namespace AppBundle\Repository;

use AppBundle\Entity\User;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query;

/**
 * PreferenceRepository
 */
class PreferenceRepository extends EntityRepository
{
    /**
     * Find preferred and active users for a given user.
     * @param  User   $user 
     * @param  int    $hydratationMode Doctrine hydratation mode.
     * @return array       
     */
    public function findPreferredByActiveUser(User $user, int $hydratationMode = Query::HYDRATE_ARRAY): array
    {
        $qb = $this->createQueryBuilder('p')
            ->leftJoin('p.selectedUser', 'u')
            ->addSelect('u')
            ->where('p.mainUser = :p_mainUser')
            ->andWhere('u.enabled = :u_enabled')
            ->andWhere('u.is_active = :u_is_active')
            ->andWhere('u.is_available = :u_is_available')
            ->setParameters([
                'p_mainUser' => $user->getId(),
                'u_enabled' => true,
                'u_is_active' => true,
                'u_is_available' => true,
            ]);
        ;

        return $qb->getQuery()->getResult($hydratationMode);
    }
}
