<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Partner;
use AppBundle\Enum\PartnerCategory;
use AppBundle\Translation\ConstTranslator;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * 
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class PartnerType extends AbstractType
{
    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->utils = $utils;
        $this->categories = $utils->trans(PartnerCategory::class);
    }
    
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('category', ChoiceType::class, array(
                'choices' => array_flip($this->categories),
                'choice_label' => function ($choiceValue, $key, $value) {
                    return 'form.partner.category.'.$choiceValue;
                },
                'label' => 'form.partner.category.label',
                'required' => true,
            ))
            ->add('selectableInPEE', CheckboxType::class, [
                'label' => 'form.partner.selectable_in_pee.label',
                'required' => false,
            ])
            ->add('displayInFront', CheckboxType::class, [
                'label' => 'form.partner.display_in_front.label',
                'required' => false,
            ])
            ->add('supportUs', CheckboxType::class, [
                'label' => 'form.partner.support_us.label',
                'required' => false,
            ])
            ->add('supportThem', CheckboxType::class, [
                'label' => 'form.partner.support_them.label',
                'required' => false,
            ])
            ->add('position', NumberType::class, array(
                'label' => 'form.partner.position.label',
                'required' => false,
            ))
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Partner::class
        ]);
    }
    /**
     * {@inheritdoc}
     */
    public function getParent()
    {
        return EstablishmentType::class;
    }
}
