<?php

namespace AppBundle\Form\Type\PEE;

use AppBundle\Entity\OperationPEECategory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use Vich\UploaderBundle\Form\Type\VichImageType;

class OperationPEECategoryType extends AbstractType
{
    private $translator;

    /**
     * Constructor
     *
     * @param TranslatorInterface $translator
     */
    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'form.name.label',
            ])
            ->add('logoFile', VichImageType::class, [
                'download_uri' => false,
                // translation domain is set to use the VichUploaderBundle domain (default setting).
                // So we have to set the label manually for this field,
                // otherwise we will have to add all the translations related to this field (field label, delete checkbox label)
                // into the 'form' domain.
                'label' => $this->translator->trans('form.logo.label', [], 'form'),
                'required' => false,
            ])
            ->add('is_active', CheckboxType::class, array(
                'label' => 'form.is_active.label',
                'required' => false,
            ))
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OperationPEECategory::class,
            'translation_domain' => 'form',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'adminbundle_operationpeecategory';
    }
}
