<?php

namespace AppBundle\Form\Type\PEE;

use AppBundle\Entity\DemandePEE;
use AppBundle\Enum\DemandePEEState;
use AppBundle\Enum\DemandePEEType as DemandePEETypeEnum;
use AppBundle\Translation\ConstTranslator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * 
 */
class DemandePEEType extends AbstractType
{
    private $translator;
    private $utils;

    /**
     * Constructor
     *
     * @param TranslatorInterface $translator
     * @param ConstTranslator $utils
     */
    public function __construct(TranslatorInterface $translator, ConstTranslator $utils)
    {
        $this->translator = $translator;
        $this->utils = $utils;
    }

    /**
    *
    * @param FormBuilderInterface $builder
    * @param array $options
    */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('state', ChoiceType::class, [
                'choices' => array_flip($this->utils->trans(DemandePEEState::class)),
                'label' => 'form.state.label',
            ])
            ->add('type', ChoiceType::class, [
                'choices' => array_flip($this->utils->trans(DemandePEETypeEnum::class)),
                'empty_data' => null,
                'expanded' => true,
                'help' => 'form.externalRegistration.help',
                'label' => 'form.externalRegistration.label',
                'placeholder' => $this->translator->trans('word.no', [], 'word'),
                'required' => false,
            ])
            ->add('note', TextareaType::class, [
                'attr' => [
                    'rows' => 5
                ],
                'label' => 'form.notes.label',
                'required' => false,
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => DemandePEE::class,
            'translation_domain' => 'form',
        ]);
    }
}
