<?php

namespace AppBundle\Form\Type\Module;

use AppBundle\Entity\Media;
use AppBundle\Entity\Module;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\ModuleType;
use AppBundle\Enum\HtmlTag;
use AppBundle\Helper\ModuleHelper;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SliderVideoType extends AbstractType
{
    private $utils;
    private $em;
    private $html_tags = array();

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils, EntityManagerInterface $em)
    {
        $this->utils = $utils;
        $this->em = $em;
        $this->html_tags = $utils->trans(HtmlTag::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $items_list = $this->em->getRepository(Media::class)->findSimpleListBy([
            'type' => 'video',
        ], [
            'title' => 'ASC'
        ]);

        // $items = $this->em->getRepository(Media::class)->findBy([
        //     'type' => 'video',
        // ], [
        //     'title' => 'ASC'
        // ]);

        // foreach ( $items as $video ) {
        //     $label = $video->getTitle();
        //     $path = $video->getPath();

        //     if (!empty($path)) {
        //         $label .= ' <small><em>( <a href="https://youtu.be/' . $path . '" target="_blank">https://youtu.be/' . $path . '</a> )</em></small>';
        //     }
            
        //     $items_list[$video->getId()] = $label;
        // }
        
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.module.slider_video.title.label',
                'required' => false,
            ))
            ->add('title_tag', ChoiceType::class, array(
                'choices' => array_flip($this->html_tags),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'label' => 'form.module.slider_video.title_tag.label',
                'placeholder' => 'form.none.label',
                'required' => false,
                'attr' => array (
                    'class' => 'form-row-childs-inline'
                )
            ))
            // ->add('items', ChoiceType::class, array(
            //     'choices' => array_flip($items_list),
            //     'choice_translation_domain' => 'form',
            //     'expanded' => true,
            //     'multiple' => true,
            //     'label' => 'form.module.slider_video.items.label',
            //     'required'  => false,
            // ))
            ->add('slide_1_video_id', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => false,
                'multiple' => false,
                'label' => 'form.module.slider_video.slide_1.video_id.label',
                'required' => true,
            ))
            ->add('slide_2_video_id', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => false,
                'multiple' => false,
                'label' => 'form.module.slider_video.slide_2.video_id.label',
                'required' => false,
            ))
            ->add('slide_3_video_id', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => false,
                'multiple' => false,
                'label' => 'form.module.slider_video.slide_3.video_id.label',
                'required' => false,
            ))
            ->add('slide_4_video_id', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => false,
                'multiple' => false,
                'label' => 'form.module.slider_video.slide_4.video_id.label',
                'required' => false,
            ))
            ->add('slide_5_video_id', ChoiceType::class, array(
                'choices' => array_flip($items_list),
                'choice_translation_domain' => 'form',
                'expanded' => false,
                'multiple' => false,
                'label' => 'form.module.slider_video.slide_5.video_id.label',
                'required' => false,
            ))
            ->add('btn_text', TextType::class, array(
                'label' => 'form.module.slider_video.btn_text.label',
                'required' => false,
            ))
            ->add('btn_link', TextType::class, array(
                'label' => 'form.module.slider_video.btn_link.label',
                'required' => false,
            ))
        ;    
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
