<?php

namespace AppBundle\Form\Type;

use AppBundle\Form\DataTransformer\MailArrayToStringTransformer;
use AppBundle\Mail\Model\Mail;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MailType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('from', TextType::class, array(
                'disabled' => true,
                'label' => 'form.from.label',
            ))
            ->add('to', TextType::class, array(
                'disabled' => true,
                'label' => 'form.to.label',
            ))
            ->add('cc', TextType::class, array(
                'disabled' => true,
                'label' => 'form.cc.label',
                'required' => false,
            ))
            ->add('subject', TextType::class, array(
                'label' => 'form.subject.label',
                'required' => false,
            ))
            ->add('html', TextareaType::class, array(
                'attr' => array('class' => 'tinymce'),
                'label' => 'form.body.label',
            ))
        ;

        $builder
            ->get('from')
            ->addModelTransformer(new MailArrayToStringTransformer());

        $builder
            ->get('to')
            ->addModelTransformer(new MailArrayToStringTransformer());

        $builder
            ->get('cc')
            ->addModelTransformer(new MailArrayToStringTransformer());
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Mail::class,
            'translation_domain' => 'form',
        ));
    }
}
