<?php

namespace AppBundle\Form\Type\Front\ITDLC\Legacy;

use AppBundle\Entity\OperationITDLC;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\ClassroomOption;
use AppBundle\Translation\ConstTranslator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProfDemandeITDLCType extends AbstractType
{
    private $classroomLevels;
    private $classroomOptions;

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->classroomLevels = $utils->trans(ClassroomLevel::class);
        $this->classroomOptions = $utils->trans(ClassroomOption::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('classLevel', ChoiceType::class, array(
                'choices' => array_flip($this->classroomLevels),
                'label' => 'form.classLevel.label',
            ))
            ->add('classOption', ChoiceType::class, array(
                'choices' => array_flip($this->classroomOptions),
                'label' => 'form.classOption.label',
                'required' => false,
            ))
            ->add('goal', TextareaType::class, array(
                'label' => 'form.goal.label',
                'help' => 'form.goal.help',
            ))
            ->add('nbStudent', IntegerType::class, array(
                'help' => 'Vous pourrez modifier cette valeur ultérieurement',
                'label' => "Nombre d'élèves prévus",
                'scale' => 0,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => OperationITDLC::class,
            'translation_domain' => 'form',
        ));
    }
}
