<?php

namespace AppBundle\Form\Type\Front\ITDLC;

use AppBundle\Entity\Company;
use AppBundle\Entity\OperationPEECategory;
use AppBundle\Entity\User;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\CompanyRepository;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\NotBlank;

/**
 *
 */
class IngeDemandeITDLCStep1Type extends AbstractType
{
    protected $transportTypeOptions;
    protected $transportDistanceOptions;
    protected $transportTimeOptions;
    protected $nbContributionsOptions;
    
    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('establishment', EntityType::class, [
                'class' => Company::class,
                'label' => 'form.profile.engineer.company.name.label',
                'query_builder' => function(CompanyRepository $er) {
                    return $er->findForUsers(true, true);
                },
                'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field display-other-field-if-no-value'
                ),
            ])
            ->add('establishmentNameOther', TextType::class, [
                'label' => 'form.profile.engineer.company.othername.label',
                'required' => false,
            ])
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.address.label',
                // 'required' => false,
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.zipcode.label',
                // 'required' => false,
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.city.label', 
                // 'required' => false,
            ))
            ->add('latitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('longitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('establishmentSector', EntityType::class, [
                'class' => OperationPEECategory::class,
                'label' => 'form.profile.engineer.company.sector.label_required', 
                'query_builder' => function(EntityRepository $er) {
                    return $er
                        ->createQueryBuilder('c')
                        ->where('c.isActive = :is_active')
                        ->setParameter('is_active', true)
                        ->orderBy('c.name')
                    ;
                },
                'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field display-other-field-if-no-value'
                ),
            ])
            ->add('establishmentSectorOther', TextType::class, [
                'label' => 'form.profile.engineer.company.sectorOther.label',
                'required' => false,
            ])
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.itdlc.next',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => User::class,
            'translation_domain' => 'form',
            'validation_groups' => [
                'add_itdlc_step1',
                'add_itdlc_engineer_step1'
            ]
        ]);
    }
}
