<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Content;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ContentType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.title.label',
            ))
            ->add('file', FileType::class, array(
                'attr' => array('class' => 'image_input'),
                'image_path' => 'webPicture',
                'label' => 'form.content.picture.label',
                'required' => false,
            ))
            ->add('introduction', TextareaType::class, array(
                'attr' => array('class' => 'tinymce tinymce-page-header'),
                'label' => 'form.content.introduction.label',
                'required' => false,
            ))
            ->add('article', TextareaType::class, array(
                'attr' => array('class' => 'tinymce tinymce-dynamic-color'),
                'label' => 'form.description.label',
                'required' => false,
            ))
            ->add('position', NumberType::class, array(
                'label' => 'form.position.label',
                'required' => false,
            ))
            ->add('publish', TextType::class, array(
                'label' => 'form.content.publish.label',
                'required' => false,
            ))
            ->addEventListener(FormEvents::PRE_SET_DATA, array($this, 'onPreSetData'))
        ;
    }

    public function onPreSetData(FormEvent $event)
    {
        $content = $event->getData();
        $form = $event->getForm();

        $metaType = ($content->getIsMain() || $content->getIsActu())
            ? TextType::class
            : HiddenType::class;

        $form
            ->add('metatitle', $metaType, array(
                'label' => 'form.meta.title.label',
                'required' => false,
            ))
            ->add('metadescription', $metaType, array(
                'label' => 'form.meta.description.label',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Content::class,
            'translation_domain' => 'form',
        ));
    }
}
