<?php

namespace AppBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use AppBundle\Translation\ConstTranslator;
use Symfony\Component\Translation\TranslatorInterface;

use AppBundle\Enum\ConfigDomainsEnum;
use AppBundle\Entity\Config;

class ConfigType extends AbstractType
{
    private $translator;
    private $utils;

    /**
     * Constructor
     * 
     * @param TranslatorInterface $translator 
     * @param ConstTranslator $utils 
     */
    public function __construct(TranslatorInterface $translator, ConstTranslator $utils)
    {
        $this->translator = $translator;
        $this->utils = $utils;
    }



    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('domain', ChoiceType::class, [
                'choices' => array_flip($this->utils->trans(ConfigDomainsEnum::class)),
                'label' => $this->translator->transchoice('form.config.domain.label', 1, [], 'form'),
                'required' => true,
            ])
            ->add('key', TextType::class, [
                'label' => $this->translator->transchoice('form.config.key.label', 1, [], 'form'),
                'required' => true,
            ])
            ->add('value', textareaType::class, [
                'label' => $this->translator->transchoice('form.config.value.label', 1, [], 'form'),
                'required' => true,
            ]);
    }
    
    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Config::class,
        ));
    }
}
