<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Company;
use AppBundle\Entity\OperationPEECategory;
use AppBundle\Repository\OperationPEECategoryRepository;
use AppBundle\Translation\ConstTranslator;
use AppBundle\Enum\PartnerGroup as PartnerGroupEnum;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use AppBundle\Enum\PartnerGroup;

/**
 * 
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class CompanyType extends AbstractType
{
    private $utils;

    private $partnerGroup;

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->utils = $utils;
        $this->em = $em;
    }
    
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('category', EntityType::class, [
                'class' => OperationPEECategory::class,
                'label' => 'form.company.category.label',
                'placeholder' => ' ',
                'query_builder' => function(OperationPEECategoryRepository $er) {
                    return $er
                        ->createQueryBuilder('c')
                        // ->where('c.isActive = :is_active')
                        // ->setParameter('is_active', true)
                        ->orderBy('c.name')
                    ;
                },
                'required' => false,
            ])
            ->add('partner_group', ChoiceType::class, [
                'choices' => array_flip($this->utils->trans(PartnerGroupEnum::class)),
                'label' => 'form.company.partnerGroup.label',
                'required' => false,
            ])
            ->add('availableForUsers', CheckboxType::class, [
                'disabled' => count($builder->getData()->getUsers()) > 0,
                'label' => 'form.company.available_for_users.label',
                'required' => false,
            ])
            ->add('selectableInPEE', CheckboxType::class, [
                'label' => 'form.company.selectable_in_pee.label',
                'required' => false,
            ]) 
            // ->add('position', NumberType::class, array(
            //     'label' => 'form.company.position.label',
            //     'required' => false,
            // ))
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Company::class
        ]);
    }
    /**
     * {@inheritdoc}
     */
    public function getParent()
    {
        return EstablishmentType::class;
    }
}
