<?php

namespace AppBundle\EventListener;

use AppBundle\History\ScreenHistory;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\FilterResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class ResponseSubscriber implements EventSubscriberInterface
{
    /**
     * @var ScreenHistory
     */
    private $screenHistory;


    public function __construct(ScreenHistory $screenHistory)
    {
        $this->screenHistory = $screenHistory;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            KernelEvents::RESPONSE => [
                'buildHistory',
            ],
        ];
    }

    /**
     *
     *
     * @param FilterResponseEvent $event
     * @return void
     */
    public function buildHistory(FilterResponseEvent $event): void
    {
        if ($event->isMasterRequest()) {
            $this->screenHistory->handle($event->getRequest(), $event->getResponse());
        }
    }
}
