<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="OperationITDLC")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\OperationItdlcRepository")
 * @ORM\HasLifecycleCallbacks
 */
class OperationITDLC
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     *
     * @var $importId
     * @ORM\Column(name="import_id", type="integer", nullable=true)
     *
     */
    protected $importId;

    /**
     * @var string $classLevel
     *
     * @ORM\Column(name="classLevel", type="string", length=150, nullable=true)
     */
    private $classLevel;

    /**
     * @var string $classOption
     *
     * @ORM\Column(name="classOption", type="string", length=150, nullable=true)
     */
    private $classOption;

    /**
     * @var string $goalCategory
     *
     * @ORM\Column(name="goal_category", type="string", length=255, nullable=true)
     */
    private $goalCategory;

    /**
     * @var string $goal
     *
     * @ORM\Column(name="goal", type="text", nullable=true)
     */
    private $goal;

    /**
     * @var string $type
     *
     * @ORM\Column(name="type", type="string", length=150, nullable=true)
     */
    private $type;

    /**
     * @var string $state
     *
     * @ORM\Column(name="state", type="string", length=150, nullable=true)
     */
    private $state;

    /**
     * @var string $note
     *
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * @var integer $nbStudent
     *
     * @ORM\Column(name="nbStudent", type="integer", nullable=true)
     */
    private $nbStudent;

    /**
     * @var string $period
     *
     * @ORM\Column(name="period", type="string", length=255, nullable=true)
     */
    private $period;

    /**
     * @var \DateTime $created
     *
     * @ORM\Column(name="created", type="date", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime $dateMail
     *
     * @ORM\Column(name="dateMail", type="date", nullable=true)
     */
    private $dateMail;

    /**
     * @var User $prof
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\User", inversedBy="profitdlc")
     * @ORM\JoinColumn(name="prof", referencedColumnName="id", nullable=true)
     */
    private $prof;

    /**
     * @var User $inge
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\User", inversedBy="ingeitdlc")
     * @ORM\JoinColumn(name="inge", referencedColumnName="id", nullable=true)
     */
    private $inge;

    /**
     * @var ArrayCollection
     * 
     * @ORM\OneToMany(targetEntity="Availability", mappedBy="operationitdlc", cascade={"remove","persist"})
     */
    private $availability;

    /**
     * @var ArrayCollection
     * 
     * @ORM\OneToMany(targetEntity="Interest", mappedBy="operationitdlc", cascade={"remove","persist"})
     */
    private $interest;

    /**
     * @var string $whoIsInCharge
     *
     * @ORM\Column(name="incharge", type="string", length=150, nullable=true)
     */
    private $whoIsInCharge;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\MerITDLC", mappedBy="ope", fetch="EXTRA_LAZY", cascade={"persist", "remove"})
     * @ORM\OrderBy({"createdAt" = "ASC"})
     */
    private $merITDLC;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->availability = new ArrayCollection();
        $this->merITDLC = new ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set classLevel
     *
     * @param string $classLevel
     * @return OperationITDLC
     */
    public function setClassLevel($classLevel)
    {
        $this->classLevel = $classLevel;

        return $this;
    }

    /**
     * Get classLevel
     *
     * @return string
     */
    public function getClassLevel()
    {
        return $this->classLevel;
    }

    /**
     * Set classOption
     *
     * @param string $classOption
     * @return OperationITDLC
     */
    public function setClassOption($classOption)
    {
        $this->classOption = $classOption;

        return $this;
    }

    /**
     * Get classOption
     *
     * @return string
     */
    public function getClassOption()
    {
        return $this->classOption;
    }

    /**
     * Set goal category
     *
     * @param string $goalCategory
     * @return OperationITDLC
     */
    public function setGoalCategory($goalCategory)
    {
        $this->goalCategory = $goalCategory;

        return $this;
    }

    /**
     * Get goal category
     *
     * @return string
     */
    public function getGoalCategory()
    {
        return $this->goalCategory;
    }

    /**
     * Set goal
     *
     * @param string $goal
     * @return OperationITDLC
     */
    public function setGoal($goal)
    {
        $this->goal = $goal;

        return $this;
    }

    /**
     * Get goal
     *
     * @return string
     */
    public function getGoal()
    {
        return $this->goal;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return OperationITDLC
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set state
     *
     * @param string $state
     * @return OperationITDLC
     */
    public function setState($state)
    {
        $this->state = $state;

        return $this;
    }

    /**
     * Get state
     *
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set note
     *
     * @param string $note
     * @return OperationITDLC
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * Set nbStudent
     *
     * @param int $nbStudent
     * @return OperationITDLC
     */
    public function setNbStudent($nbStudent)
    {
        $this->nbStudent = $nbStudent;

        return $this;
    }

    /**
     * Get nbStudent
     *
     * @return integer
     */
    public function getNbStudent()
    {
        return $this->nbStudent;
    }

    /**
     * Set period
     *
     * @param int $period
     * @return OperationITDLC
     */
    public function setPeriod($period)
    {
        $this->period = $period;

        return $this;
    }

    /**
     * Get period
     *
     * @return integer
     */
    public function getPeriod()
    {
        return $this->period;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return OperationITDLC
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->created = new \DateTime();
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set prof
     *
     * @param User $prof
     * @return OperationITDLC
     */
    public function setProf(User $prof)
    {
        $this->prof = $prof;

        return $this;
    }

    /**
     * Get prof
     *
     * @return User
     */
    public function getProf()
    {
        return $this->prof;
    }

    /**
     * Set inge
     *
     * @param User $inge
     * @return OperationITDLC
     */
    public function setInge(User $inge = null)
    {
        $this->inge = $inge;

        return $this;
    }

    /**
     * Get inge
     *
     * @return User
     */
    public function getInge()
    {
        return $this->inge;
    }

    /**
     * Set dateMail
     *
     * @param \DateTime $dateMail
     * @return OperationITDLC
     */
    public function setDateMail($dateMail)
    {
        $this->dateMail = $dateMail;

        return $this;
    }

    /**
     * Get dateMail
     *
     * @return \DateTime
     */
    public function getDateMail()
    {
        return $this->dateMail;
    }

    /**
     * Set importId
     *
     * @param int $importId
     * @return OperationITDLC
     */
    public function setImportId($importId)
    {
        $this->importId = $importId;

        return $this;
    }

    /**
     * Get importId
     *
     * @return integer
     */
    public function getImportId()
    {
        return $this->importId;
    }

    /**
     * Add availability
     *
     * @param Availability $availability
     * @return OperationITDLC
     */
    public function addAvailability(Availability $availability)
    {
        $this->availability[] = $availability;
        $availability->setOperationitdlc($this);

        return $this;
    }

    /**
     * Remove availability
     *
     * @param Availability $availability
     */
    public function removeAvailability(Availability $availability)
    {
        $this->availability->removeElement($availability);
    }

    /**
     * Remove all availability
     *
     */
    public function removeAllAvailability()
    {
        $this->availability->clear();
    }

    /**
     * Get availability
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAvailability()
    {
        return $this->availability;
    }

    /**
     * Add interest
     *
     * @param Interest $interest
     * @return OperationITDLC
     */
    public function addInterest(Interest $interest)
    {
        $this->interest[] = $interest;
        $interest->setOperationitdlc($this);

        return $this;
    }

    /**
     * Remove interest
     *
     * @param Interest $interest
     */
    public function removeInterest(Interest $interest)
    {
        $this->interest->removeElement($interest);
    }

    /**
     * Get interest
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getInterest()
    {
        return $this->interest;
    }

    /**
     * Set whoIsInCharge
     *
     * @param string $whoIsInCharge
     * @return OperationITDLC
     */
    public function setWhoIsInCharge($whoIsInCharge)
    {
        $this->whoIsInCharge = $whoIsInCharge;

        return $this;
    }

    /**
     * Get whoIsInCharge
     *
     * @return string
     */
    public function getWhoIsInCharge()
    {
        return $this->whoIsInCharge;
    }

    /**
     * Get merITDLC
     *
     * @return ArrayCollection
     */
    public function getMerITDLC()
    {
        return $this->merITDLC;
    }

    /**
     * Get last merITDLC
     *
     * @return merITDLC
     */
    public function getLastMerITDLC()
    {
        return $this->getMerITDLC()->last();
    }

    /**
     * Add merITDLC.
     *
     * @param \AppBundle\Entity\MerITDLC $merITDLC
     *
     * @return OperationITDLC
     */
    public function addMerITDLC(\AppBundle\Entity\MerITDLC $merITDLC)
    {
        if ($this->merITDLC->contains($merITDLC)) {
            return;
        }
        
        $this->merITDLC[] = $merITDLC;
        $merITDLC->setOpe($this);

        return $this;
    }

    /**
     * Remove merITDLC.
     *
     * @param \AppBundle\Entity\MerITDLC $merITDLC
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeMerITDLC(\AppBundle\Entity\MerITDLC $merITDLC)
    {
        return $this->merITDLC->removeElement($merITDLC);
    }
}
