<?php

namespace AppBundle\Controller\Module;

use AppBundle\Controller\ModuleController;
use AppBundle\Entity\Menu;
use AppBundle\Entity\Module;
use AppBundle\Entity\Testimonial;
use AppBundle\Enum\UserType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

class TestimonialsListController extends ModuleController
{
    /**
     * @param Int $moduleId Défini le module à afficher
     * @param string $force_layout Définit le type de rendu Twig souhaité
     * @param Int $menuId Défini le menu associé, la page actuelle qui demande l'affichage
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function renderModule(Int $moduleId, string $force_layout = null, Int $menuId = null)
    {
        $module = $this->em->getRepository(Module::class)->findOneBy([
            'isActive' => true, 
            'id' => $moduleId
        ]);
        
        if (empty($module)) {
            return new Response('');
        }

        //Force layout
        if (!empty($force_layout)) {
            $module->setLayout($force_layout);
        }
        
        $module->setFormClass($module->getType());
        $layout = $module->getLayoutPath();

        //Check if layout is correct
        if (!empty($force_layout) && strpos($layout, $force_layout) === false) {
            return new Response('');
        }

        $mode = $module->getParams()->mode;

        if($mode == "created") {
            //Mode Created
            $testimonials = $this->em->getRepository(Testimonial::class)->findBy(
            [], 
            ['created' => 'DESC'], 
            (int) $module->getParams()->nb_items);
        }
        elseif($mode == "featured") {
            $listIds = (array) $module->getParams()->items;
            $testimonials = $this->em->getRepository(Testimonial::class)->findBy([
                'id' => $listIds
            ], 
            ['created' => 'DESC']);    
        }

        if (empty($testimonials)) {
            return new Response('');
        }

        // Specific to layout cols.html.twig
        switch ( count($testimonials) ) {
            case 1 :
            case 2 :
            case 3 :
                    $itemClass = "col-lg-6 col-xl-4 add-spacing";
                    break;
            case 4 : 
            default:
                    $itemClass = "col-lg-6 col-xl-3 add-spacing";
                    break;
        }

        $menuList = $this->em->getRepository(Menu::class)->findOneBy([
                'typeTemplate' => 10, 
        ]);

        return $this->render($layout , array(
            'module' => $module, 
            'menu' => $menuList,
            'testimonials' => $testimonials,
            'mode' => $mode,
            'itemcol' => $itemClass,
        ));
    }
}
