<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Entity\Slider;
use AppBundle\Form\Type\SliderType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Translation\TranslatorInterface;

class SliderController extends Controller
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * @var TranslatorInterface
     */
    private $translator;
    
    public function __construct(EntityManagerInterface $em, TranslatorInterface $translator)
    {
        $this->em = $em;
        $this->translator = $translator;
    }

    /**
     * Liste des sliders
     *
     * @Route(
     *      "/slider",
     *      name = "admin_slider"
     * )
     */
    public function indexAction()
    {
        $slides = $this->em->getRepository(Slider::class)->findBy([], [
            'position' => 'ASC',
            'id' => 'ASC',
        ]);

        return $this->render('Admin/Slider/index.html.twig', array(
            'sliders' => $slides,
        ));
    }


    /**
     * Ajout d'un slider
     *
     * @Route(
     *      "/slider/add",
     *      name = "admin_slider_add"
     * )
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function addAction(Request $request)
    {
        $slide = new Slider;

        $form = $this->createForm(SliderType::class, $slide);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($slide);
            $this->em->flush();

            $this->addFlash('success', $this->translator->trans('notice.slider.added', [], 'notice'));

            return $this->redirectToRoute('admin_slider_edit', array(
                'id' => $slide->getId(),
            ));
        }

        return $this->render('Admin/Slider/add.html.twig', array(
            'form' => $form->createView(),
        ));
    }


    /**
     * Modification d'un slider
     *
     * @Route(
     *      "/slider/edit/{id}",
     *      requirements = {"id": "\d+"},
     *      name = "admin_slider_edit"
     * )
     *
     * @param Request $request
     * @param Slider $slider
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, Slider $slider)
    {
        $form = $this->createForm(SliderType::class, $slider);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            if ($request->get('remove_picture')) {
                $slider->setPicture(null);
            }
            $this->em->persist($slider);
            $this->em->flush();

            $this->addFlash('success', $this->translator->trans('notice.slider.updated', [], 'notice'));

            return $this->redirectToRoute('admin_slider_edit', array(
                'id' => $slider->getId(),
            ));
        }

        return $this->render('Admin/Slider/add.html.twig', array(
            'form' => $form->createView(),
        ));
    }
}
