<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Entity\OperationPEECategory;
use AppBundle\Form\Type\PEE\OperationPEECategoryType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * Operationpeecategory controller.
 *
 * @Route("/settings/operation-pee/category")
 */
class OperationPEECategoryController extends Controller
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * @var TranslatorInterface
     */
    private $translator;
    
    public function __construct(EntityManagerInterface $em, TranslatorInterface $translator)
    {
        $this->em = $em;
        $this->translator = $translator;
    }

    /**
     * Lists all operationPEECategory entities.
     *
     * @Route(
     *     "/{page}",
     *     name="operationpee_category_index",
     *     requirements={"page": "\d+"},
     * )
     * @Method("GET")
     * @param Request $request
     * @param int $page
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Exception
     */
    public function indexAction(Request $request, int $page = 1)
    {
        $criteria = [];
        if (null !== $name = $request->query->get('name')) {
            $criteria['name'] = ['like', $name];
        }
        $resultsMaxPerPage = $this->getParameter('results.admin.max_per_page');

        $categories = $this->em->getRepository(OperationPEECategory::class)->paginate(
            $criteria,
            ['name' => 'ASC'],
            $resultsMaxPerPage,
            ($page - 1) * $resultsMaxPerPage,
            ['peeOperations']
        );

        return $this->render('Admin/Settings/operationpee-category/index.html.twig', [
            'nb_pages' => ceil(count($categories) / $resultsMaxPerPage),
            'categories' => $categories,
        ]);
    }

    /**
     * Creates a new operationPEECategory entity.
     *
     * @Route("/add", name="operationpee_category_add")
     * @Method({"GET", "POST"})
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function addAction(Request $request)
    {
        $operationPEECategory = new Operationpeecategory();
        $form = $this->createForm(OperationPEECategoryType::class, $operationPEECategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($operationPEECategory);
            $this->em->flush();

            return $this->redirectToRoute('operationpee_category_edit', ['id' => $operationPEECategory->getId()]);
        }

        return $this->render('Admin/Settings/operationpee-category/add.html.twig', [
            'operationPEECategory' => $operationPEECategory,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Displays a form to edit an existing operationPEECategory entity.
     *
     * @Route("/{id}/edit", name="operationpee_category_edit")
     * @Method({"GET", "POST"})
     * @param Request $request
     * @param OperationPEECategory $operationPEECategory
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, OperationPEECategory $operationPEECategory)
    {
        $editForm = $this->createForm(OperationPEECategoryType::class, $operationPEECategory);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->em->flush();

            $this->addFlash('success', $this->translator->trans(
                'notice.operationPee.category.updated',
                ['%name%' => $operationPEECategory->getName()],
                'notice'
            ));

            return $this->redirectToRoute('operationpee_category_edit', ['id' => $operationPEECategory->getId()]);
        }

        return $this->render('Admin/Settings/operationpee-category/edit.html.twig', [
            'operationPEECategory' => $operationPEECategory,
            'edit_form' => $editForm->createView(),
        ]);
    }

    /**
     * Deletes a operationPEECategory entity.
     *
     * @Route("/{id}", name="operationpee_category_delete")
     * @Method({"GET"})
     *
     * @param OperationPEECategory $operationPEECategory
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(OperationPEECategory $operationPEECategory)
    {
        if (!$operationPEECategory->isDeletable()) {
            throw $this->createAccessDeniedException($this->translator->trans('notice.operationPee.category.removed.failure', [], 'notice'));
        }

        $this->em->remove($operationPEECategory);
        $this->em->flush();

        return $this->redirectToRoute('operationpee_category_index');
    }
}
