<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20170723125041 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('CREATE SEQUENCE establishment_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE establishment (id INT NOT NULL, name VARCHAR(255) NOT NULL, description TEXT DEFAULT NULL, website VARCHAR(255) DEFAULT NULL, logoPath VARCHAR(255) DEFAULT NULL, logoSize INT DEFAULT NULL, available_for_users BOOLEAN DEFAULT \'false\' NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, updated_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, type VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_DBEFB1EE5E237E06 ON establishment (name)');
        $this->addSql('ALTER TABLE operationpee ADD company_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE operationpee ADD CONSTRAINT FK_2299D2B6979B1AD6 FOREIGN KEY (company_id) REFERENCES establishment (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('CREATE INDEX IDX_2299D2B6979B1AD6 ON operationpee (company_id)');
        $this->addSql('ALTER TABLE fos_user ADD establishment_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE fos_user ADD CONSTRAINT FK_957A64798565851 FOREIGN KEY (establishment_id) REFERENCES establishment (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('CREATE INDEX IDX_957A64798565851 ON fos_user (establishment_id)');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('ALTER TABLE OperationPEE DROP CONSTRAINT FK_2299D2B6979B1AD6');
        $this->addSql('ALTER TABLE fos_user DROP CONSTRAINT FK_957A64798565851');
        $this->addSql('DROP SEQUENCE establishment_id_seq CASCADE');
        $this->addSql('DROP TABLE establishment');
        $this->addSql('DROP INDEX IDX_2299D2B6979B1AD6');
        $this->addSql('ALTER TABLE OperationPEE DROP company_id');
        $this->addSql('DROP INDEX IDX_957A64798565851');
        $this->addSql('ALTER TABLE fos_user DROP establishment_id');
    }
}
