<?php

namespace AppBundle\Twig;

class ReplaceExtension extends \Twig_Extension
{
    /**
     * Returns a list of filters.
     *
     * @return array
     */
    public function getFilters(): array
    {
        return [
            new \Twig_SimpleFilter('preg_replace',  [$this, 'replace']),
        ];
    }

    public function replace(string $subject, string $pattern, string $replacement): string
    {
        return preg_replace($pattern, $replacement, $subject);
    }
}
