<?php

namespace AppBundle\Twig;

use AppBundle\Translation\ConstTranslator;

/**
 *
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class ConstTranslationExtension extends \Twig_Extension
{
    private $constTranslator;

    /**
     * Constructor
     * @param ConstTranslator $constTranslator
     */
    public function __construct(ConstTranslator $constTranslator)
    {
        $this->constTranslator = $constTranslator;
    }

    /**
     *
     * @return array
     */
    public function getFilters(): array
    {
        return array(
            new \Twig_SimpleFilter('transconst', array($this, 'constTranslationFilter')),
        );
    }

    /**
     *
     * @param null|int|string $const
     * @param  string $classname
     * @param  string $translationSuffix
     * @return string Translated string
     * @throws \ReflectionException
     */
    public function constTranslationFilter($const, string $classname, string $translationSuffix = 'label'): string
    {
        if (!empty($const)) {
            $translations = $this->constTranslator->trans($classname, $const, $translationSuffix);
            return array_shift($translations);
        }

        return "";
    }
}
