<?php

namespace AppBundle\Menu\Admin;

use Knp\Menu\FactoryInterface;
use Knp\Menu\ItemInterface;
use Symfony\Component\Translation\TranslatorInterface;

class ActionPeeBuilder
{
    /**
     * @var FactoryInterface
     */
    private $factory;

    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(FactoryInterface $factory, TranslatorInterface $translator)
    {
        $this->factory = $factory;
        $this->translator = $translator;
    }

    /**
     * @return ItemInterface
     */
    public function operation(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.operationPee.label', [], 'action'),
                'route' => 'admin_operation_pee_new',
            ])
            ->setLinkAttribute('class', 'btn btn-add')
        ;

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function operationCategory(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.operationPee.category', [], 'action'),
                'route' => 'operationpee_category_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add');

        return $menu;
    }
}
