<?php

namespace AppBundle\Helper;

use AppBundle\Entity\User;
use AppBundle\Entity\Establishment;
use AppBundle\Entity\Company;
use AppBundle\Entity\Partner;
use AppBundle\Enum\EstablishmentAcademy;
use FOS\UserBundle\Model\UserManagerInterface;

class UserHelper
{
    protected static $userManager;

    /**
     * Set FOS User Manager
     * 
     * @param UserManagerInterface $translator 
     */
    public function setUserManager(UserManagerInterface $userManager): void
    {
        self::$userManager = $userManager;
    }
    
    /**
     * Generate username
     *
     * @param User $user
     * @return string
     */
    public static function generateUsername(User $user)
    {        
        $username = time() . rand(1000, 9999); // By default, unique username

        $firstname = strtolower($user->getFirstname());
        $lastname = strtolower($user->getLastname());

        $username = $origin_username = $firstname.'-'.$lastname;
        
        $i = 1;
        while (self::isUsernameAlreadyExists($username)) {
            $username = $origin_username . '-' . $i++;
        }

        return $username;   
    }

    /**
     * Generate username
     *
     * @param User $user
     * @return string
     */
    private static function isUsernameAlreadyExists(string $username)
    {        
        $userExists = self::$userManager->findUserByUsername($username);

        if (!empty($userExists)) {
            return true;
        }

        return false;   
    }

    /**
     * Generate shoe size options
     *
     * @return array
     */
    public static function getShoeSizeOptions()
    {        
        $shoeSizeOptions = array('' => '');
        for ($i = 33; $i <= 50 ; $i++) {
            $shoeSizeOptions[$i] = $i;
        }
        
        return $shoeSizeOptions;
    }

    /**
     * Generate transport Type options
     *
     * @return array
     */
    public static function getTransportTypeOptions()
    {        
        $transportTypeOptions = array(
            0 => 'form.profile.engineer.publictransport.options.car',
            1 => 'form.profile.engineer.publictransport.options.public',
        ); 
        
        return $transportTypeOptions;
    }

    /**
     * Generate transport Distance options
     *
     * @return array
     */
    public static function getTransportDistanceOptions()
    {        
        $transportDistanceOptions = array(
            30 => 'form.profile.engineer.transportkm.options.0a30',
            60 => 'form.profile.engineer.transportkm.options.30a60',
            1000 => 'form.profile.engineer.transportkm.options.60etplus',
        );
        
        return $transportDistanceOptions;
    }

    /**
     * Generate transport time options
     *
     * @return array
     */
    public static function getTransportTimeOptions()
    {        
        $transportTimeOptions = array(
            30 => 'form.profile.engineer.transporttime.options.0a30',
            45 => 'form.profile.engineer.transporttime.options.30a45',
            600 => 'form.profile.engineer.transporttime.options.45etplus',
        );

        return $transportTimeOptions;
    }

    /**
     * Generate nb contributions options
     *
     * @return array
     */
    public static function getNbContributionsOptions()
    {        
        $nbContributionsOptions = array('' => '');
        for ($i = 1; $i <= 5 ; $i++) {
            $nbContributionsOptions[$i] = $i;
        }
        
        return $nbContributionsOptions;
    }

    /**
     * Get Academy list
     *
     * @return Array
     */
    public static function getAcademyList()
    {        
        $list = array();

        $consts = EstablishmentAcademy::getConstants();
        
        $list = array_combine($consts, $consts);

        asort($list);

        return $list;
    }
}
