<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Menu;
use AppBundle\Entity\Testimonial;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\DataTransformer\NumberToLocalizedStringTransformer;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TestimonialType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('witness', TextType::class, array(
                'label' => 'form.testimonial.witness.label',
                'required' => true,
            ))
            ->add('occupation', TextType::class, array(
                'label' => 'form.testimonial.occupation.label',
                'required' => true,
            ))
            ->add('content', TextareaType::class, array(
                'attr' => array('class' => 'tinymce'),
                'label' => 'form.testimonial.content.label',
                'required' => false,
            ))
            ->add('filePicture', FileType::class, array(
                'attr' => array('class' => 'image_input'),
                'image_path' => 'webPicture',
                'label' => 'form.testimonial.picture.label',
                'help' => 'form.testimonial.picture.help',
                'required' => false,
            ))
            /* ->add('is_active', CheckboxType::class, array(
                'label' => 'form.testimonial.is_active.label',
                'required' => false,
            )) */
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Testimonial::class,
            'translation_domain' => 'form',
        ));
    }
}
