<?php

namespace AppBundle\Form\Type\Front\User;

use AppBundle\Entity\Company;
use AppBundle\Entity\OperationPEECategory;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserJobEngineer;
use AppBundle\Enum\UserJobEngineerCategory;
use AppBundle\Enum\UserSchoolGrade;
use AppBundle\Enum\UserType;
use AppBundle\Form\Type\Front\User\ProfileFormType;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\CompanyRepository;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use FOS\UserBundle\Form\Type\ProfileFormType as BaseProfileFormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\NotBlank;

/**
 *
 */
class ProfileIngeFormType extends ProfileFormType
{
    protected $transportTypeOptions;
    protected $transportDistanceOptions;
    protected $transportTimeOptions;
    protected $nbContributionsOptions;
    
    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        parent::__construct($ur, $utils);

        $this->jobsCategories = $utils->trans(UserJobEngineerCategory::class);
        $this->jobs = $utils->trans(UserJobEngineer::class, null, null, null, true);
        $this->classroomLevels = $utils->trans(ClassroomLevel::class);
        $this->formations = $utils->trans(UserSchoolGrade::class);

        $this->transportTypeOptions = UserHelper::getTransportTypeOptions();
        $this->transportDistanceOptions = UserHelper::getTransportDistanceOptions();
        $this->transportTimeOptions = UserHelper::getTransportTimeOptions();
        $this->nbContributionsOptions = UserHelper::getNbContributionsOptions();
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $this->buildUserForm($builder, $options);
        $this->buildCompanyForm($builder, $options);
        $this->buildPasswordForm($builder, $options);
        $this->buildCommunicationForm($builder, $options);
        
        $builder 
            ->add('submit', SubmitType::class, array(
                'label' => 'form.profile.submit',
                'attr' => array(
                    'class' => 'btn btn-block btn-md btn-theme'
                ),
            ))
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options
     */
    public function buildUserForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildUserForm($builder, $options);

        $builder
            // ->add('categoryJob', ChoiceType::class, [
            //     'choices' => array_flip($this->jobsCategories),
            //     'label' => 'form.profile.engineer.jobcategory.label',
            //     'required' => false,
            // ])
            ->add('job', ChoiceType::class, array(
                'choices' => array_flip($this->jobs),
                'label' => 'form.profile.engineer.job.label',
                'required' => true,
                // 'attr' => array(
                //     'class' => 'relationship-with-other-field'
                // ),
            ))
            ->add('jobOther', TextType::class, [
                'label' => 'form.profile.engineer.jobother.label',
                'required' => true,
            ])
            ->add('formation', ChoiceType::class, [
                'choices' => array_flip($this->formations),
                'label' => 'form.profile.engineer.formation.label',
                'required' => true,
            ])
            ->add('formationType', TextType::class, [
                'label' => 'form.profile.engineer.formationType.label',
                'required' => true,
            ])
            ->add('aboutMe', TextareaType::class, [
                'label' => 'form.profile.engineer.aboutme.label',
                'required' => true,
            ])
            // ->add('briefing', TextareaType::class, [
            //     'label' => 'Thèmes et objectifs envisagés de la future intervention',
            //     'required' => false,
            // ])
            ->add('publictransport', ChoiceType::class, [
                'choices' => array_flip($this->transportTypeOptions),
                'label' => 'form.profile.engineer.publictransport.label',
                'required' => true,
            ])
            ->add('transportkm', ChoiceType::class, [
                'choices' => array_flip($this->transportDistanceOptions),
                'label' => 'form.profile.engineer.transportkm.label',
                'required' => true,
            ])
            ->add('transporttime', ChoiceType::class, [
                'choices' => array_flip($this->transportTimeOptions),
                'label' => 'form.profile.engineer.transporttime.label',
                'required' => true,
            ])
            ->add('classroom', ChoiceType::class, [
                'label' => 'form.profile.engineer.classroom.label',
                'choices' => array_flip($this->classroomLevels),
                'multiple' => true,
                'expanded' => true,
                'required' => true,
            ])
            ->add('nbcontribution', ChoiceType::class, [
                'choices' => array_flip($this->nbContributionsOptions),
                'label' => 'form.profile.engineer.nbcontribution.label',
                'placeholder' => 'CHoisissez un nb d\'interventions',
                'required' => true,
            ])
            ->add('availabilities', CollectionType::class, [
                'label' => 'form.profile.availabilities.label',
                'entry_type' => ChoiceType::class,
                'entry_options' => array(
                    'label' => false,
                    'choices' => array(
                        'word.everytime.label' => '',
                        'word.days.label' => array_flip(array(
                            'monday' => 'word.days.monday.label',
                            'tuesday' => 'word.days.tuesday.label',
                            'wednesday' => 'word.days.wednesday.label',
                            'thursday' => 'word.days.thursday.label',
                            'friday' => 'word.days.friday.label',
                            // 'saturday' => 'word.days.saturday.label',
                            // 'sunday' => 'word.days.sunday.label',
                        )),
                        'word.months.label' => array_flip(array(
                            'january' => 'word.months.january.label',
                            'february' => 'word.months.february.label',
                            'march' => 'word.months.march.label',
                            'april' => 'word.months.april.label',
                            'may' => 'word.months.may.label',
                            'june' => 'word.months.june.label',
                            // 'july' => 'word.months.july.label',
                            // 'august' => 'word.months.august.label',
                            'september' => 'word.months.september.label',
                            'october' => 'word.months.october.label',
                            'november' => 'word.months.november.label',
                            'december' => 'word.months.december.label',
                        )),
                    ),
                    'translation_domain' => 'form',
                    'choice_translation_domain' => 'word',
                ),
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'label_add' => 'form.collection.btn.availabilities.add',
                'label_delete' => 'form.collection.btn.availabilities.delete',
                'error_bubbling' => false,
                'required' => true,
            ])
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildCompanyForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('establishment', EntityType::class, [
                'class' => Company::class,
                'label' => 'form.profile.engineer.company.name.label',
                'query_builder' => function(CompanyRepository $er) {
                    return $er->findForUsers(true, true);
                },
                'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field display-other-field-if-no-value'
                ),
            ])
            ->add('establishmentNameOther', TextType::class, [
                'label' => 'form.profile.engineer.company.othername.label',
                'required' => false,
            ])
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.address.label',
                'required' => true,
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.zipcode.label',
                'required' => true,
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.city.label', 
                'required' => true,
            ))
            ->add('latitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('longitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('establishmentSector', EntityType::class, [
                'class' => OperationPEECategory::class,
                'label' => 'form.profile.engineer.company.sector.label', 
                'query_builder' => function(EntityRepository $er) {
                    return $er
                        ->createQueryBuilder('c')
                        ->where('c.isActive = :is_active')
                        ->setParameter('is_active', true)
                        ->orderBy('c.name')
                    ;
                },
                'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field display-other-field-if-no-value'
                ),
            ])
            ->add('establishmentSectorOther', TextType::class, [
                'label' => 'form.profile.engineer.company.sectorOther.label',
                'required' => false,
            ])
        ;
    }

    /**
     *
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'translation_domain' => 'form',
            'validation_groups' => [
                'profile',
                'profile_engineer'
            ]
        ]);
    }
}
