<?php

namespace AppBundle\Form\Type\Front\User\Legacy;

use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\UserJobTeacher;
use AppBundle\Helper\UserHelper;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use AppBundle\Enum\UserRep;
use AppBundle\Repository\UserRepository;

/**
 *
 */
class RegistrationStep2ProfFormType extends AbstractType
{
    private $academies;
    private $classrooms;
    private $jobs;
    private $repLevels;

    /**
     * Construcltor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        // $this->academies = array_column($ur->findAcademies(Query::HYDRATE_ARRAY), 'academy', 'academy');
        $this->academies = UserHelper::getAcademyList();
        $this->classrooms = $utils->trans(ClassroomLevel::class);

        // $this->jobs = array(
        //     'Professeur d\'Arts plastiques' => 'Professeur d\'Arts plastiques',
        //     'Professeur d\'Education musicale' => 'Professeur d\'Education musicale',
        //     'Professeur de Mathématiques' => 'Professeur de Mathématiques',
        //     'Professeur de Physique - chimie' => 'Professeur de Physique - chimie',
        //     'Professeur de Sciences de la vie et de la Terre' => 'Professeur de Sciences de la vie et de la Terre',
        //     'Professeur de Technologie' => 'Professeur de Technologie',
        //     'Professeur d\'Éducation civique, juridique et sociale' => 'Professeur d\'Éducation civique, juridique et sociale',
        //     'Professeur d\'Éducation physique et sportive' => 'Professeur d\'Éducation physique et sportive',
        //     'Professeur d\'Histoire-Géographie' => 'Professeur d\'Histoire-Géographie',
        //     'Professeur de Français' => 'Professeur de Français',
        //     'Professeur de Langue vivante' => 'Professeur de Langue vivante',
        //     'Professeur de Sciences de l\'Ingénieur' => 'Professeur de Sciences de l\'Ingénieur',
        //     'Chef d\'établissement' => 'Chef d\'établissement',
        //     'Chef de travaux' => 'Chef de travaux'
        // );

        $this->jobs = $utils->trans(UserJobTeacher::class);
        
        $this->repLevels = $utils->trans(UserRep::class);
    }

    /**
     *
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('job', ChoiceType::class, array(
                'attr' => array('class' => 'jobform'),
                'choices' => $this->jobs,
                'empty_data' => null,
                'label' => 'Matière enseignée',
                'placeholder' => ' ',
            ))
            ->add('jobOther', TextType::class, array(
                'attr' => array('class' => 'jobotherform'),
                'label' => 'Autre',
                'required' => false,
            ))
            ->add('professionalDiscover', ChoiceType::class, array(
                'choices' => array(
                    'Oui' => true,
                    'Non' => false,
                ),
                'expanded' => true,
                'label' => 'Enseignez-vous la découverte professionnelle ?',
            ))
            ->add('classroom', ChoiceType::class, array(
                'choices' => array_flip($this->classrooms),
                'expanded' => true,
                'label' => 'form.classroom.label',
                'multiple' => true,
                'required' => false,
            ))
            ->add('establishmentName', TextType::class, array(
                'label' => 'Nom de l\'établissement scolaire',
            ))
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'Adresse de l\'établissement',
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'Code postal de l\'établissement',
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'Ville de l\'établissement',
            ))
            // ->add('establishmentEmail', TextType::class, array(
            //     'label' => 'Email de l\'établissement',
            //     'required' => false,
            // ))
            ->add('academy', ChoiceType::class, array(
                'choices' => $this->academies,
                'label' => 'form.academy.label',
                'placeholder' => 'Choisissez une académie',
            ))
            ->add('rep', ChoiceType::class, array(
                'choices' => array_flip($this->repLevels),
                'expanded' => true,
                'label' => 'form.rep.label',
            ))
            ->add('newsletter', CheckboxType::class, array(
                'label' => 'Je souhaite recevoir la newsletter C.Genial',
                'required' => false,
            ))
            ->add('bossEmail', TextType::class, array(
                'label' => 'Email chef d\'établissement',
                'help' => 'Indiquez-le si vous souhaitez qu\'il soit mis en copie des mails de confirmation de participation aux différentes opérations auxquelles vous avez choisi de participer',
                'required' => false,
            ))
            ->add('type', HiddenType::class, array(
                'data' => $options['data']->getType(),
                'required' => false,
            ))
            ->add('latitude', HiddenType::class, array(
                'required' => false,
            ))
            ->add('longitude', HiddenType::class, array(
                'required' => false,
            ))
            ->add('submit', SubmitType::class, array(
                'label' => 'registration.submit',
                'translation_domain' => 'FOSUserBundle',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ))
        ;
    }

    /**
    *
    * @param OptionsResolver $resolver
    */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
            'validation_groups' => array('registration_step2_prof')
        ));
    }
}
