<?php

namespace AppBundle\Form\Type\Front\User\Legacy;

use AppBundle\Entity\Company;
use AppBundle\Repository\CompanyRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RegistrationStep2IngeFormType extends AbstractType
{
    /**
     *
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            // Professional information
            ->add('job', TextType::class, [
                'label' => 'Métier',
            ])
            ->add('establishment', EntityType::class, [
                'class' => Company::class,
                'label' => 'Nom entreprise',
                'query_builder' => function(CompanyRepository $er) {
                    return $er->findForUsers(true, true);
                },
                'required' => false,
            ])
            ->add('establishmentNameOther', TextType::class, [
                'label' => 'Autre',
                'required' => false,
            ])
            ->add('establishmentAddress', TextType::class, [
                'label' => 'Adresse de lʼentreprise',
            ])
            ->add('establishmentZipcode', TextType::class, [
                'label' => 'Code postal de lʼentreprise',
            ])
            ->add('establishmentCity', TextType::class, [
                'label' => 'Ville de lʼentreprise',
            ])
            ->add('latitude', HiddenType::class, [
                'required' => false
            ])
            ->add('longitude', HiddenType::class, [
                'required' => false
            ])

            // Personal address
            ->add('personalZipcode', TextType::class, [
                'label' => 'Code postal de résidence',
            ])
            ->add('personalCity', TextType::class, [
                'label' => 'Ville de résidence',
            ])
            ->add('personalLatitude', HiddenType::class, [
                'required' => false
            ])
            ->add('personalLongitude', HiddenType::class, [
                'required' => false
            ])


            ->add('detailFunction', TextareaType::class, [
                'label' => 'Détails de votre fonction professionnelle',
                'required' => false
            ])
            ->add('detailFormation', TextareaType::class, [
                'label' => 'Détails de votre formation',
                'required' => false
            ])
            ->add('newsletter', CheckboxType::class, [
                'label' => 'Je souhaite recevoir la newsletter C.Genial',
                'required' => false
            ])
            ->add('type', HiddenType::class, [
                'data' => $options['data']->getType(),
                'required' => false
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'registration.submit',
                'translation_domain' => 'FOSUserBundle',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ])
        ;
    }

    /**
     *
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'translation_domain' => 'form',
            'validation_groups' => ['registration_step2_inge'],
        ]);
    }
}
