<?php

namespace AppBundle\Form\Type\Front;

use AppBundle\Entity\Contact;
use AppBundle\Enum\ContactCategory;
use AppBundle\Enum\ContactSubject;
use AppBundle\Translation\ConstTranslator;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use AppBundle\Enum\UserType;

class ContactFormType extends AbstractType
{
    
    private $categories = array();
    private $subjects = array();
    
    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->utils = $utils;
        $this->categories = $utils->trans(ContactCategory::class, null, null, null, true);
        $this->subjects = $utils->trans(ContactSubject::class);
    }
    
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('firstname', TextType::class, array(
                'label' => 'form.contact.firstname.label',
                'required' => false,
            ))
            ->add('lastname', TextType::class, array(
                'label' => 'form.contact.lastname.label',
                'required' => false,
            ))
            ->add('company', TextType::class, array(
                'label' => 'form.contact.company.label',
                'required' => false,
            ))
            ->add('email', EmailType::class, array(
                'label' => 'form.contact.email.label',
                'required' => true,
            ))
            ->add('category', ChoiceType::class, array(
                'choices' => array_flip($this->categories),
                'choice_label' => function ($choiceValue, $key, $value) {
                    if (empty($choiceValue)) {
                        return $key;
                    }
                    return 'form.contact.category.'.$choiceValue;
                },
                'label' => 'form.contact.category.label',
                'required' => true,
            ))
            // @NOTE Demande client. Hide subject
            // ->add('subject', ChoiceType::class, array(
            //     'choices' => array_flip($this->subjects),
            //     'choice_label' => function ($choiceValue, $key, $value) {
            //         return 'form.contact.subject.'.$choiceValue;
            //     },
            //     'label' => 'form.contact.subject.label',
            //     'required' => true,
            // ))
            ->add('subject', HiddenType::class, array(
                'attr' => array(
                    'value' => ContactSubject::INFORMATIONS,
                ),
                'required' => true,
            ))
            ->add('message', TextareaType::class, array(
                'label' => 'form.contact.message.label',
                'required' => true,
            ))
            ->add('message', TextareaType::class, array(
                'label' => 'form.contact.message.label',
                'required' => true,
            ))
            ->add('submit', SubmitType::class, [
                'label' => 'form.contact.send.label',
                'attr' => array(
                    'class' => 'btn btn-block btn-md btn-pelorous'
                ),
            ])
        ;   
    }

    /**
     * 
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'class' => Contact::class,
            'translation_domain' => 'form'
        ]);

        $resolver->setRequired('google_recaptcha_public_key');
    }
}