<?php

namespace AppBundle\Form\DataTransformer;

use Symfony\Component\Form\DataTransformerInterface;
use Doctrine\Common\Collections\ArrayCollection;
use AppBundle\Entity\MerItdlc;

class CollectionToEntityTransformer implements DataTransformerInterface
{
    /**
     * Transforms a collection of merITDLC to a merITDLC entity.
     *
     * @param Collection  Array keys = mail addresses; array values = mail labels
     * @return Entity MerITDLC 
     */
    public function transform($collection): MerITDLC
    {
        if (count($collection) == 1) {
            $entity = $collection[0];
        } else {
            $entity = null;
        }

        return $entity;
    }

    /**
     * Transforms an entity to a collection.
     *
     * @param  Entity
     * @return array
     */
    public function reverseTransform($entity): ArrayCollection 
    {
        $collection = new ArrayCollection();

        if ($entity) {
            $collection->add($entity);
        }

        return $collection;
    }
}
